package Evo::Loop;
use Evo '-Realm *; -Export *; -Realm *';
use Evo ':Comp';

use constant DEFAULT => Evo::Loop::Comp::new();

sub start : Export(loop_start) { realm_lord(DEFAULT)->start(@_) }

sub timer : Export(loop_timer) { realm_lord(DEFAULT)->timer(@_); }

sub timer_remove : Export(loop_timer_remove) {
  realm_lord(DEFAULT)->timer_remove(@_);
}


sub handle : Export(loop_handle)             { realm_lord(DEFAULT)->handle(@_) }
sub handle_catch : Export(loop_handle_catch) { realm_lord(DEFAULT)->handle_catch(@_) }

sub handle_remove : Export(loop_handle_remove) {
  realm_lord(DEFAULT)->handle_remove(@_);
}


sub postpone : prototype(&) : Export(loop_postpone) { realm_lord(DEFAULT)->postpone(@_) }

sub zone : Export(loop_zone) { realm_lord(DEFAULT)->zone(@_) }

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop

=head1 VERSION

version 0.0182

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
