package Evo::Loop::Role::Postpone;
use Evo '-Comp::Role *';

requires qw(zone_cb);

has data_postpone => default => sub { [] };

sub postpone_count($self) : Role { $self->data_postpone->@* }
sub postpone($self, $fn) : Role { push $self->data_postpone->@*, $self->zone_cb($fn); }

sub postpone_process($self) : Role {
  my $postpone = $self->data_postpone;
  shift(@$postpone)->() while @$postpone;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Loop::Role::Postpone

=head1 VERSION

version 0.0177

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
