package Evo::Realm;
use Evo '-Export *', '-Lib *';
use Evo::Util;
use Carp 'croak';
use Scalar::Util qw(refaddr blessed);


my %REALM;
sub REALM_DATA { \%REALM }

export_gen realm => sub {
  my $key = shift;
  sub {
    return $REALM{$key} if exists $REALM{$key};
    $_[0] ? $_[0] : croak qq{not in realm of "$key"};
  };
};

export_gen realm_run => sub {
  my $key = shift;
  sub {
    my ($obj, $fn) = (shift, pop);
    ref $obj eq $key or croak qq{Broken REALM "$obj" isn't instance of "$key"};
    local $REALM{$key} = $obj;
    $fn->(@_);
  };
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Realm

=head1 VERSION

version 0.0173

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
