package Evo::Comp::Hash;
use Evo '-Export *';
use Evo::Lib 'monkey_patch';
use Evo '::Gen::Hash GEN; ::Role ROLE_EXPORTER';
use Evo '::Meta';

my $META = Evo::Comp::Meta::new(gen => GEN, rex => ROLE_EXPORTER);

export_gen new => sub { $META->compile_builder(shift); };

export_gen has => sub {
  my $class = shift;
  sub { $META->install_attr($class, @_); };
};

export_gen with => sub {
  my $class = shift;
  sub { $META->install_roles($class, @_); };
};


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Comp::Hash

=head1 VERSION

version 0.0173

=head1 DESCRIPTION

Hash based driver for L<Evo::Comp>

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
