use Evo '-Lib *', '-Want *';
use Test::More;

VOID: {
  my $res = context_run(WANT_VOID, sub { return '34' });
  is_deeply $res, [WANT_VOID];
}

SCALAR: {
  my $res = context_run(WANT_SCALAR, sub { my @arr = (0, 0, 0); @arr });
  is_deeply $res, [WANT_SCALAR, 3];


  $res = context_run(WANT_SCALAR, sub { return 'foo' });
  is_deeply $res, [WANT_SCALAR, 'foo'];

  $res = context_run(WANT_SCALAR, sub {return});
  is_deeply $res, [WANT_SCALAR, undef];
}

LIST: {
  my $res = context_run(WANT_LIST, sub { return ('foo') });
  is_deeply $res, [WANT_LIST, ['foo']];

  $res = context_run(WANT_LIST, sub { return (1, 2, 3) });
  is_deeply $res, [WANT_LIST, [1, 2, 3]];

}

done_testing;
