package Boa;
use Evo '-Single *', 'Boa::Runner', '-Ws *', '-Flow *', 'Evo::W::Stash *', '-Expo *', 'Boa::Spy';

export qw(domain test), map {"$_:boa_$_"} qw(spy add_wrappers add_thunks domain_stash);


my $CLASS = 'Boa::Runner';
sub current_runner { ($CLASS->realm_check || single_get($CLASS)) }

sub spy { Boa::Spy->new(origin => $_[0]) }
sub add_wrappers { $CLASS->realm_object->add_wrappers(@_) }
sub add_thunks   { $CLASS->realm_object->add_thunks(@_) }
sub domain_stash { $CLASS->realm_object->domain_stash(@_) }

sub test(&) {
  my %attrs;
  @attrs{qw(path line)} = (caller())[1, 2];
  add_test(%attrs, @_);
}


sub add_test {
  my $fn    = pop;
  my %attrs = @_;

  $attrs{fn} = sub {
    my $result   = shift;
    my $stash    = $result->merge_stashes;
    my @wrappers = reverse map { @{$_->wrappers} } @{$result->domain_path};

    my $runner = Boa::Runner->realm_object;
    my $change = sub { $runner->change_result($result, @_); };

    flow_run w_stash_init(%$stash, change => $change, result => $result), @wrappers, $fn;
  };

  $CLASS->realm_object->add_test(Boa::Test->new(%attrs));
}

sub domain(&) { add_domain(@_) }

sub add_domain {
  my $fn = pop;
  current_runner()->add_domain(Boa::Domain->new(@_), $fn);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Boa

=head1 VERSION

version 0.0172

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
