use Evo;
use Test::More 'skip_all';
use Railway::Util 'curry_wrappers';
use Railway::Builder;

my $bldr = Railway::Builder->new;
is $bldr->curry_wrappers()->(sub {'foo'})->(), 'foo', 'right result';

my $w_mngr = sub($m, $cb) {
  sub(@args) { $m, $cb->(@args) }
};

my $fired = 0;

# return mngr and args
is_deeply [$bldr->curry_wrappers($w_mngr)->(sub { $fired++; @_ })->(1, 2)],
  [$bldr, 1, 2], 'right result';
is $fired, 1, 'fired once';

# same but twice
is_deeply [$bldr->curry_wrappers($w_mngr, $w_mngr)->(sub {@_})->(1, 2)],
  [$bldr, $bldr, 1, 2], 'right result';
is $fired, 1, 'fired once';

done_testing;

