use Evo;
use Benchmark ':all';
use Test::More;
use Evo::Spy;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 85_000 * $ENV{TEST_EVO_PERF};
my $N      = 200_000;


my $k = 0;

my $t = timeit(
  $N,
  sub {
    Evo::Spy->new(sub { $k++ })->();
  }
);

diag timestr $t;

BAIL_OUT "increase N " unless $t->cpu_a > 0;
ok $k == $N, "$k = $N";
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
