package main;
use Evo ':all';
use Test::More;
use Benchmark ':all';

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 1_700_000;
my $N      = 2_000_000;

{

  package MyFoo;
  use Evo -class;

}

my ($t_evo, $t_pure);
call {foo => 'MyFoo'}, sub {
  $t_evo = timeit($N, sub { die unless dep_single('foo')->isa('MyFoo') });
};

my $perf_evo = $N / $t_evo->cpu_a;
diag $perf_evo;
ok $perf_evo > $EXPECT, "$perf_evo > $EXPECT";

done_testing;
