package main;
use Evo;
use Test::More tests => 5;
use Evo::Mdn;
use Test::Fatal;
use Evo::Util::Mdn ':all';

my $mdn    = Evo::Mdn->new;
my $sender = My::Obj->new;
my $buggy  = MyBuggy->new;

$mdn->subscribe($buggy, $sender, 1);

ok is_subscribed $mdn, $buggy, $sender;
ok is_stored $mdn,     $buggy, $sender;

like exception {
  $mdn->broadcast($sender, 'hello');
},
  qr/Foo/;

ok !is_subscribed $mdn, $buggy, $sender;
ok !is_stored $mdn,     $buggy, $sender;

{

  package My::Obj;
  use Evo -class;

  package MyBuggy;
  use Evo -class;
  sub when_message { die "Foo" }
}

done_testing;


