package main;
use Evo;
use Test::More;
use Test::Fatal;

my (@destroyed, @created, $fired);


FOO: {
  my $flow = MyFlow->new;
  $flow->asap(
    sub {
      use Data::Dumper;
      $flow->asap(sub { $fired++ });
    }
  );
}

ok $fired;
ok scalar @created;
is_deeply [sort @created], [sort @destroyed];

{

  package MyFlow;
  use Evo 'Evo::Flow';
  sub new { my $self = shift; push @created, $self; $self->SUPER::new(@_) }
  sub DESTROY { my $self = shift; push @destroyed, ref $self; }
}

done_testing;

