use Evo ':dep';
use Test::More;
use Test::Fatal;

plan tests => 10;

my $fn = Evo::fn {foo => 'MyFoo'}, sub { is dep('foo'), 'MyFoo' };
$fn->();

# while call uses fn, we test it instead of fn

# existing
Evo::call {foo => 'MyFoo'}, sub {
  ok dep_exists 'foo';
  ok !dep_exists 'bar';
  is dep('foo'), 'MyFoo';
};

# empty
#Evo::call sub { ok !dep_exists('no') };

# not existing - exception
Evo::call {foo => 'No matter'}, sub {
  like exception { dep('not_exists') }, qr /Unmet dependency not_exists/;
};

# localized
Evo::call {}, sub {
  Evo::call {not_exists => 'bad'}, sub { };
  like exception { dep('not_exists') }, qr /Unmet dependency not_exists/;
};

# extends but skips existing
Evo::call {foo => 'MyFoo'}, sub {
  Evo::call {foo => 'Bad', bar => 'MyBar'} => sub {
    is dep('foo'), 'MyFoo';
    is dep('bar'), 'MyBar';
  };
};

# args
my @args;
Evo::fn({}, sub { @args = @_ })->();
ok !@args;

Evo::fn({}, sub { @args = @_ })->(3, 4);
is_deeply \@args, [3, 4];

done_testing;
