package main;
use Evo ':all';
use Test::More;


{

  package My::Inline;
  use Evo -class;

  package My::Inline::Sub;
  use Evo 'My::Inline';

  package My::Inline::Mock;
  use Evo 'My::Inline';
};

# glob
my $obj = dep_single 'My::Inline';
isa_ok $obj, 'My::Inline';
is $obj,     dep_single 'My::Inline';

my $sub_obj = dep_single My::Inline::Sub;
isa_ok $sub_obj, 'My::Inline::Sub';
is $sub_obj,     dep_single My::Inline::Sub;

# mock in evo
call {'My::Inline' => 'My::Inline::Mock'}, sub {
  my $mock_obj = dep_single My::Inline;
  isa_ok $mock_obj, 'My::Inline::Mock';
};

done_testing;
