package Evo::Dsl;
use Evo -class;
use Evo::Util;
use Evo::Guard;

# return dsl_stash, or value by key
# if not exists, return false without error
sub check_stash {
  my ($self, $key) = @_;
  my $cur = $self->{STASH} or return;
  $key ? exists $cur->{$key} : $cur;
}

sub stash { Evo::Util::_dsl_stash('STASH', @_) }

sub depth { $_[0]->{dsl_depth} //= 0 }

# initialize dsl
sub call {
  my ($self, $cb) = (shift, pop);
  local $self->{STASH} = shift // {};

  $self->{dsl_depth}++;
  my $guard = Evo::dep_new Evo::Guard, sub { $self->{dsl_depth}--; };
  $cb->(@_);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Dsl

=head1 VERSION

version 0.0170

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
