use Evo::Base -strict;
use Test::More tests => 6;
use Evo::Guard;
use Test::Fatal;

TEST: {
  my @res;
GUARD: {
    my $guard = Evo::Guard->new(always => sub { push @res, 'a' });
  }
  is_deeply \@res, ['a'];
}

TEST: {
  my $res;

  like exception {
    my $guard = Evo::Guard->new(error => sub { $res = shift });
    die 'SuperError';
  }, qr/SuperError/;

  like $res, qr/SuperError/;
}

TEST: {
  my @res;
GUARD: {
    my $guard = Evo::Guard->new(
      error  => sub { push @res, 'e' },
      always => sub { push @res, 'a' }
    );
  }
  is_deeply \@res, ['a'];
}

TEST: {
  my @res;
  like exception {
    my $guard = Evo::Guard->new(
      error  => sub { push @res, 'e' },
      always => sub { push @res, 'a' }
    );
    die 'foo';
  }, qr/foo/;
  is_deeply \@res, ['e', 'a'];
}
