use Evo::Base -strict;
use Railway::Builder;
use Benchmark ':all';
use Test::More;
use Evo::Spy;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $bldr = Railway::Builder->new;

my $EXPECT = 180_000 * $ENV{TEST_EVO_PERF};
my $N      = 100_000;


my $k   = 0;
my $sub = sub { $k++ };
my $spy = Evo::Spy->new(origin => $sub);

my $t = timeit($N, sub { $spy->() });
diag timestr $t;
is scalar $spy->calls->@*, $N;

BAIL_OUT "increase N " unless $t->cpu_a > 0;
ok $k == $N, "$k = $N";
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";

done_testing;
