package main;
use Evo::Base -strict;
use Test::More;
use Evo::MDN;
use Test::Fatal;

my ($FROM, $MSG);
my $mdn  = Evo::MDN->new;
my $from = Receiver->new;
my $me   = Receiver->new;

$mdn->subscribe($me, $from);
$mdn->broadcast($from, 'foo');

is $FROM, $from;
is $MSG,  'foo';

# unsubscribe, must be unchanged
$mdn->unsubscribe($me, $from);
$mdn->broadcast($from, 'BAD');
is $FROM, $from;
is $MSG,  'foo';

# must be empty
($FROM, $me, $from) = ();
is_deeply $mdn->_all_senders, {};

{

  package Receiver;
  use Evo::Base -base;
  sub when_message($self, $msg, $from) { $FROM = $from; $MSG = $msg }
}

done_testing;
