use Evo::Base -strict;
use Evo::Util;
use Test::More tests => 9;
use Test::Fatal;

# wantarray
my @res
  = Evo::Util::_guard_on_die {fail} sub { is wantarray, 1, 'list'; (1, 2) };
is_deeply \@res, [1, 2], 'right result';

my $res = Evo::Util::_guard_on_die {fail}
sub { ok defined wantarray, 'scalar'; 'val' };
is $res, 'val', 'right result';

Evo::Util::_guard_on_die {fail} sub { ok !defined wantarray, 'void' };

# die
my $fired;
my $die = sub { die "Foo" };

$fired = 0;
like exception {
  Evo::Util::_guard_on_die { $fired++; } $die;
}, qr/Foo/, 'right exception raised';
is $fired, 1, 'was fired';

$fired = 0;
like exception {
  Evo::Util::_guard_on_die { $fired++; die "New" } $die;
}, qr/New/, 'new exception';
is $fired, 1, 'was fired';
