use Evo::Base -strict;
use Test::More tests => 5;
use Evo::Manager;

my $m = Evo::Manager->singleton;

my $train = $m->build_train;
my @passed;
$train->asap(
  sub {
    push @passed, 1;
    $train->asap(sub { push @passed, 3 }, sub { push @passed, 4 });
  },
  sub { push @passed, 2 }
);

$train->asap(sub { push @passed, 5 });
is_deeply \@passed, [1, 2, 3, 4, 5], 'right order';


# dsl_depth
$train->asap(
  sub {
    is $m->dsl_depth, 1;
    $train->asap(sub { is $m->dsl_depth, 1; }, sub { is $m->dsl_depth, 1; });
  },
  sub { push @passed, 2; is $m->dsl_depth, 1; }
);
done_testing;
