package main;
use Evo::Base -strict;
use FindBin;
use Test::More;
use Test::Fatal;

{

  package MyClass;
  use Evo::Base 'Railway::Cleanup';

  __PACKAGE__->attr_cleanup(['foo', 'bar']);
  has 'ok';

  package MySubClass;
  use Evo::Base 'MyClass';

  has 'sub_ok';
  __PACKAGE__->attr_cleanup('sub_baz');
}


# cleanup_lists
my $o = MyClass->new;
is($o->foo(2)->foo, 2, 'right attr');
is($o->foo(2)->foo, 2, 'right attr');

is_deeply [$o->cleanup_list],       ['foo', 'bar'];
is_deeply [(ref $o)->cleanup_list], ['foo', 'bar'];


# cleanup_lists in class and parents
my $obj = MySubClass->new;
is($obj->foo(2)->foo,         2, 'right attr');
is($obj->sub_baz(2)->sub_baz, 2, 'right attr');

is_deeply [MySubClass::->cleanup_list], [qw(sub_baz foo bar)], 'right list';
is_deeply [MySubClass::->new->cleanup_list], [qw(sub_baz foo bar)],
  'right list by instance';


# perform cleanup in class
$o = MyClass->new->foo('foo')->bar('bar');
$o->cleanup;
is_deeply [$o->foo, $o->bar], [undef, undef], 'cleared';

# perform cleanup in class and parents
$obj = MySubClass->new(
  foo     => 'foo',
  bar     => 'bar',
  sub_baz => 'sub_baz',
  ok      => 'ok',
  sub_ok  => 'sub_ok'
);
is_deeply [$obj->foo, $obj->bar, $obj->sub_baz, $obj->ok, $obj->sub_ok],
  [qw(foo bar sub_baz ok sub_ok)], 'right init';
$obj->cleanup;

is_deeply [$obj->foo, $obj->bar, $obj->sub_baz, $obj->ok, $obj->sub_ok],
  [undef, undef, undef, 'ok', 'sub_ok'], 'right cleanup result';

# try_or_cleanup
$obj = MySubClass->new(foo => 'foo', ok => 'ok');
is_deeply [$obj->try_or_cleanup(sub { (1, 2) })], [1, 2,], 'right return';
is_deeply [$obj->try_or_cleanup(sub {'ok'})], ['ok'], 'right return';
is $obj->foo, 'foo', 'not cleared';

# die and cleanup
like exception {
  $obj->try_or_cleanup(sub { die "MyError" })
}, qr/MyError/, 'died';
is $obj->foo, undef, 'cleared';
is $obj->ok,  'ok',  'not cleared';

done_testing;
