package Railway::Builder;
use Evo::Base -base;

has train_class => sub { require Railway::Train; 'Railway::Train'; };
has way_class   => sub { require Railway::Way;   'Railway::Way'; };

sub build_train($self, %args) {
  $args{way} //= $self->build_way;
  $args{manager} = $self;
  $self->train_class->new(%args);
}

sub build_way($self,%args) { $self->way_class->new(%args); }

1;

# ABSTRACT: a builder

__END__

=pod

=encoding UTF-8

=head1 NAME

Railway::Builder - a builder

=head1 VERSION

version 0.008

=head1 SYNOPSIS

  my $bldr  = Railway::Builder->new;
  my $train = $bldr->build_train;
  my $way   = $bldr->build_way;

=head1 ATTRIBUTES

=head2 train_class

  class for train instances

=head2 way_class

  class for way instances

=head1 METHODS

=head2 build_train

  build a train

=head2 build_way

  build a way

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
