# Evo - Perl Evo design pattern [![Build Status](https://travis-ci.org/alexbyk/perl-evo.svg?branch=v0.002)](https://travis-ci.org/alexbyk/perl-evo)


## DESCRIPTION

    A tiny framework for organizing non-trivial code into simple logic.
    It includes benefits from functional and OO style programming.

    Write fast, reuseble and testable code.
    Familiar with OO? - Use it. Familiar with higher-order functions? - Use it.
    Familiar with non-blocking style? - Use it. Want DSL? - Use it.

    Do it the right way.

## Synopsis
```perl
use Evo::Base -strict;
use Evo::Manager;
my $mngr = Evo::Manager->new;

# next tick
my $runner = $mngr->build_train;
our $state = 'non blocking';

# always nb
$runner->asap(
  sub {
    say $state;
    local $state = 'blocking?';
    $runner->asap(sub { say $state });
  }
);

# dsl
# prints 1;2;foo
my @args = (1, 2);
my $print = sub(@args) { local $, = ';'; say @args, $mngr->current('foo') };
$mngr->dsl_call({foo => 'foo'}, @args, $print);

# currying
my $debug = sub($evo, $next) {
  sub(@args) {
    say 'Got args: ', join ';', @args;
    $next->(@args);
    }
};

my $safe = sub($evo, $next) {
  sub(@args) {
    local $@;
    eval { $next->(@args) };
    warn "catched: $@" if $@;
    }
};

my $die = sub {die};
my $curry = $mngr->curry_wrappers($debug, $safe);
$curry->(sub { say "going to die"; die })->(1, 2);

my $way = $mngr->build_way;
my $train = $mngr->build_train(way => $way);
$way->curry($curry)->add(sub { say 'step1'; })->add(sub { die "step 2" })
  ->add(sub { say "step 3"; });

$train->start;
```
## AUTHOR

alexbyk.com

## COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
