package Bio::Roary::External::Revtrans;

# ABSTRACT: Wrapper around RevTrans


use Moose;

has 'nucleotide_filename'  => ( is => 'ro', isa => 'Str', required => 1 );
has 'protein_filename'     => ( is => 'ro', isa => 'Str', required => 1  );
has 'output_filename'      => ( is => 'ro', isa => 'Str', required => 1  );
has 'exec'                 => ( is => 'ro', isa => 'Str', default  => 'revtrans.py' );
has 'translation_table'           => ( is => 'rw', isa => 'Int',  default  => 11 );


sub _command_to_run {
    my ($self) = @_;
    return join(
        " ",
        (
            $self->exec,      
            $self->nucleotide_filename,
            $self->protein_filename,
            '-mtx', $self->translation_table,
            '-readthroughstop',
            '-allinternal', 
            '-match', 'name',
            '>', $self->output_filename
        )
    );
}

sub run {
  my ($self) = @_;
  my $cmd = $self->_command_to_run;
  system($cmd);
  1;
}

no Moose;
__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Bio::Roary::External::Revtrans - Wrapper around RevTrans

=head1 VERSION

version 2.0.1

=head1 SYNOPSIS

Take in a fasta file and create a temporary blast database.

   use Bio::Roary::External::Revtrans;
   
   my $blast_database= Bio::Roary::External::Revtrans->new(
     nucleotide_filename => 'contigs.fa',
     protein_filename  => 'proteins.faa'
     output_filename   => 'translated.fa.aln'
   );
   
   $blast_database->run();

=head1 AUTHOR

Andrew J. Page <ap13@sanger.ac.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2013 by Wellcome Trust Sanger Institute.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
