package P::Util::Resources;

use P;

no P;

our $ROOT = [];

my $res_index;

for ( $PROC->{RESOURCES_DIR}, $DIST->{RESOURCES_DIR}, $P->{RESOURCES_DIR} ) {
    next if !$_;

    push $ROOT, $_ if !$res_index->{$_}++;
}

# add PCORE_MOUNTED_RESOURCES
if ( $ENV{PCORE_MOUNTED_RESOURCES} && -d $ENV{PCORE_MOUNTED_RESOURCES} ) {
    my $path = P->file->path( $ENV{PCORE_MOUNTED_RESOURCES}, is_dir => 1 )->realpath;

    unshift $ROOT, $path if !$res_index->{$path}++;
}

our $_ROOT_CACHE = {};

sub root ($self) {
    return $ROOT;
}

sub get_local ( $self, $path ) {
    for my $root ( $ROOT->@* ) {
        if ( my $found_path = $self->_find_resource( $root, q[local], $path ) ) {
            return $found_path;
        }
    }

    return;
}

sub get_share ( $self, $path ) {
    for my $root ( $ROOT->@* ) {
        if ( my $found_path = $self->_find_resource( $root, q[share], $path ) ) {
            return $found_path;
        }
    }

    return;
}

sub _find_resource ( $self, $root, $location, $path ) {
    if ( !exists $_ROOT_CACHE->{$root}->{$location} ) {
        $_ROOT_CACHE->{$root}->{$location} = P->file->path( $root . q[/] . $location . q[/] );
    }

    $root = $_ROOT_CACHE->{$root}->{$location};

    my $root_path = P->file->path( q[./] . $path, base => $root );

    if ( $root_path->is_file && -f $root_path && index( $root_path, $root, 0 ) == 0 ) {
        return $root_path;
    }

    return;
}

sub copy_local ( $self, $from, $to ) {
    for my $root ( reverse $ROOT->@* ) {
        P->file->copy( qq[$root/local/$from], qq[$to/local/$from] ) if -e qq[$root/local/$from];
    }

    return;
}

sub copy_share ( $self, $from, $to ) {
    for my $root ( reverse $ROOT->@* ) {
        P->file->copy( qq[$root/share/$from], qq[$to/share/$from] ) if -e qq[$root/share/$from];
    }

    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

P::Util::Resources

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
