package Pcore::Proxy::Source::Tor;

use Pcore qw[-class];

with qw[Pcore::Proxy::Source];

has host         => ( is => 'ro', isa => Str,         default   => '127.0.0.1' );
has port         => ( is => 'ro', isa => PositiveInt, default   => 9050 );
has control_port => ( is => 'ro', isa => PositiveInt, default   => 9051 );
has password     => ( is => 'ro', isa => Str,         predicate => 1 );

no Pcore;

# NOTE it's important to use "persistent" = 0 in AnyEvent::HTTP, otherwise all connections will not use NEWNYM, if NYM changed

sub load ( $self, $cb ) {
    $cb->( [ 'socks5://' . $self->host . q[:] . $self->port ] );

    return;
}

sub update_proxy_status ( $self, $proxy ) {

    # don't ban proxy, get new identity instead
    if ( $proxy->is_banned ) {
        $self->new_identity;

        $proxy->_set_is_banned(0);

        return;
    }

    $self->_pool->update_proxy_status($proxy);

    return;
}

sub id ($self) {
    return $self->_id;
}

# TODO implement with AnyEvent::Handle
sub new_identity ($self) {
    my $socket = IO::Socket::INET->new(
        PeerAddr => $self->host,
        PeerPort => $self->control_port,
        Proto    => 'tcp'
    ) or die;

    my $password = $self->has_password ? $self->password : q[];

    print {$socket} qq[AUTHENTICATE "$password"${CRLF}SIGNAL NEWNYM${CRLF}QUIT${CRLF}];

    $socket->close;

    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Proxy::Source::Tor

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
