package Pcore::Pg v0.6.0;

use Pcore -dist, -class;

has data => ( is => 'ro', isa => Str, required => 1 );

sub run ( $self, $cb ) {

    # create and prepare data dir
    P->file->mkdir( $self->data ) if !-d $self->data;
    my $uid = getpwnam 'postgres';
    chown $uid, $uid, $self->data or die;

    # init db
    if ( $self->is_empty ) {
        my $res = P->pm->run_proc( [ 'su', 'postgres', '-c', "$ENV{POSTGRES_HOME}/bin/pg_ctl initdb -D " . $self->data ] );

        exit 3 if !$res;

        P->file->write_text(
            $self->data . '/pg_hba.conf',
            [    #
                q[local all all trust],           # trust any user, connected via unix socket
                q[host all all 0.0.0.0/0 md5],    # require password, when user is connected via TCP
            ]
        );

        P->file->append_text(
            $self->data . '/postgresql.conf',
            [                                     #
                q[listen_addresses='*'],
                q[unix_socket_directories='/tmp/pgsql.sock'],
            ]
        );
    }

    # create and prepare unix socket dir
    P->file->mkdir('/tmp/pgsql.sock') if !-d '/tmp/pgsql.sock';
    chown $uid, $uid, '/tmp/pgsql.sock' or die;

    # run server
    P->pm->run_proc(
        [ 'su', 'postgres', '-c', "$ENV{POSTGRES_HOME}/bin/postgres -D " . $self->data ],
        on_finish => sub ($proc) {
            $cb->($proc);

            return;
        }
    );

    return;
}

sub is_empty ($self) {
    return P->file->read_dir( $self->data )->@* ? 0 : 1;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Pg

=head1 SYNOPSIS

=head1 DESCRIPTION

    docker create --name pgsql -v postgres:/var/local/pcore-pg/data/ -v /tmp/pgsql.sock/:/tmp/pgsql.sock/ -p 5432:5432/tcp softvisio/pcore-pg

    # connect via TCP
    my $dbh = P->handle('pg://username:password@host:port?db=dbname');

    # connect via unix socket
    my $dbh = P->handle('pg://username:password@/tmp/pgsql.sock?db=dbname');

=head1 SEE ALSO

=head1 AUTHOR

zdm <zdm@cpan.org>

=head1 CONTRIBUTORS

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by zdm.

=cut
