package Pcore::Handle::MySQL;

use Pcore qw[-class];
use DBD::mysql;

with qw[Pcore::DBD];

has '+h_disconnect_on' => ( isa => Enum [ 'PID_CHANGE', 'REQ_FINISH' ], default => 'REQ_FINISH' );

has addr     => ( is => 'ro', isa => Str, required => 1 );    # use unix:/var/lib/mysql/mysql.sock as default unix socket
has schema   => ( is => 'ro', isa => Str, required => 1 );
has username => ( is => 'ro', isa => Str, required => 1 );
has password => ( is => 'ro', isa => Str, required => 1 );

# DBD
sub _build__connection {
    my $self = shift;

    my $attr = P->hash->merge(
        $self->_default_attr,
        {   mysql_enable_utf8      => 1,
            mysql_auto_reconnect   => 1,
            mysql_multi_statements => 1,
        }
    );

    my $addr = P->uri( $self->addr );

    my $host;

    if ( $addr->scheme eq 'unix' ) {
        $host = q[];

        $attr->{mysql_socket} = $addr->path;
    }
    else {
        $host = $addr->host_port;
    }

    return [ q[DBI:mysql:database=] . $self->schema . qq[;host=$host], $self->username, $self->password, $attr ];
}

sub auto_reconnects_ok {
    my $self = shift;

    return $self->h->{mysql_dbd_stats}->{auto_reconnects_ok};
}

sub auto_reconnects_failed {
    my $self = shift;

    return $self->h->{mysql_dbd_stats}->{auto_reconnects_failed};
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Handle::MySQL

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
