package Pcore::Captcha v0.7.0;

use Pcore -dist, -class;

with qw[Pcore::Util::Status::Role];

has captcha => ( is => 'ro', isa => ScalarRef, required => 1 );

has phrase   => ( is => 'ro', isa => Bool, default => 0 );    # 1 = captcha has 2-3 words
has regsense => ( is => 'ro', isa => Bool, default => 0 );    # 1 = captcha is case sensitive
has numeric => ( is => 'ro', isa => Enum [ 0, 1, 2 ], default => 0 );    # 1 = captcha consists of digits only, 2 = captcha does not contain any digits
has calc       => ( is => 'ro', isa => Bool,              default => 0 );    # 1 = arithmetical operation must be performed
has min_len    => ( is => 'ro', isa => PositiveOrZeroInt, default => 0 );    # 1..20 = minimum length of captcha text required to input
has max_len    => ( is => 'ro', isa => PositiveOrZeroInt, default => 0 );    # 1..20 = maximum length of captcha text required to input
has is_russian => ( is => 'ro', isa => Bool,              default => 0 );    # 1 = captcha goes to Russian Queue
has type => ( is => 'ro', isa => Enum [qw[recaptcha2 recaptcha2_44 recaptcha2_24]] );
has comment => ( is => 'ro', isa => Str );                                   # Option 1. Send along with any captcha to make it more clear for workers, Option 2. Send without captcha if you just want to ask a question (example: "What color is the sky?")

has id => ( is => 'ro', isa => Maybe [Int], init_arg => undef );
has result => ( is => 'ro', isa => Str, init_arg => undef );

has '+status' => ( required => 0, init_arg => undef );

1;
__END__
=pod

=encoding utf8

=cut
