#!/usr/bin/env perl

package main v0.1.0;

use Pcore;
use Pcore::API::Whois;

sub CLI ($self) {
    return {
        opt => { export => { desc => 'export supported pub. suffixes', }, },
        arg => [
            domain => {
                isa => 'Str',
                min => 1,
                max => 1,
            },
        ],
    };
}

my $w = Pcore::API::Whois->new;

if ( $ENV->cli->{opt}->{export} ) {
    $w->export_supported_pub_suffixes;
}
else {
    say dump $w->search( $ENV->cli->{arg}->{domain} );
}

1;
__END__
=pod

=encoding utf8

=cut
