# Note: this file has been initially generated by Module::Build::Convert 0.25

use strict;
#use warnings;
use Module::Build;
use Getopt::Long;
use File::Find;

my $XML_parser = undef;
my( $with_axkit, $with_tomkit ) = ( undef, undef );
my @pm_dirs = ( qw/ lib / );

GetOptions( 'parser=s' => \$XML_parser,
             'axkit!'  => \$with_axkit,
             'tomkit!' => \$with_tomkit );

$XML_parser = choose_parser( $XML_parser );

unless ( $with_axkit ) {
    $with_axkit ||= eval 'use AxKit; 1';
    print 'AxKit ', 'not 'x!$with_axkit, "detected\n";
}
if ( $with_axkit ) {
    print "adding Apache::Axkit::Language::YPathScript to installation\n";
    push @pm_dirs, 'lib_axkit';
}

unless ( $with_tomkit ) {
    $with_tomkit ||= eval 'use Apache2::TomKit; 1';
    print 'TomKit ', 'not 'x!$with_tomkit, "detected\n";
}
if ( $with_tomkit ) {
    print "adding Apache2::Tomkit::Processor::XPathScript to installation\n";
    push @pm_dirs, 'lib_tomkit';
}

my $class = Module::Build->subclass
    (code => <<"PROPAGATE_VARIABLES"
our \$XML_parser = '$XML_parser';
our \$with_axkit = '$with_axkit';
our \$with_tomkit = '$with_tomkit';
PROPAGATE_VARIABLES
     . <<'CODE');
use strict;
use warnings;

use File::Spec ();

sub process_pm_files {
    my $self = shift;
    $self->SUPER::process_pm_files(@_);

    my $outfile = File::Spec->catfile(qw(blib lib XML XPathScript.pm));
    unlink($outfile);
    my $in = new IO::File("lib/XML/XPathScript.pm", "<") or die "$!";
    my $out = new IO::File($outfile, ">") or die "$!";
    while(<$in>) {
          s/^(\$XML_parser = )'.*?';$/$1'$XML_parser';/;
          $out->print($_);
      }
}

CODE

my %pm_files;
find(\&find_module, @pm_dirs);

my $build = $class->new
  (
   module_name => 'XML::XPathScript',
   dist_author => [ 'Yanick Champoux <yanick@cpan.org>',
                    'Dominique Quatravaux <domq@cpan.org> ',
                    'Matt Sergeant <matt@sergeant.org>' ],
   dist_version_from => 'lib/XML/XPathScript.pm',
   license => 'artistic',
   requires => {
                $XML_parser 	 => 0,
                'Carp' 			 => 0,
                'Symbol' 		 => 0,
                'File::Basename' => 0,
                'IO::File' 	 	 => 0,
                'Data::Dumper'   => 0,
                'Scalar::Util'   => 0,
                'Readonly'       => 0,
                'Clone'          => 0,
               },
   build_requires => {
                      "File::Find" => 0,
                      "File::Spec" => 0,
                     },
   pm_files => \%pm_files,
   script_files => [ qw#  script/xpathscript # ],
   create_makefile_pl => 'passthrough',
   sign => 1,
  );

$build->create_build_script;

sub choose_parser {
	my( $XML_parser ) = @_;

	if( $XML_parser ) {
		unless( grep $XML_parser eq $_, qw/ XML::XPath XML::LibXML / ) {
			die "XML parser $XML_parser not supported\n",
				"please choose XML::XPath or XML::LibXML\n";
		}
	
		print "XML parser configured to be $XML_parser\n";

		return $XML_parser;
	}

	print "detecting XML parser...\n";

	print "checking if XML::LibXML is present.. ";
	if ( $XML_parser = eval "use XML::LibXML; 'XML::LibXML'" ) { 
		print "XML::LibXML detected, good!\n",
              "setting XML parser to XML::LibXML\n";
		return $XML_parser;
	}
	print "XML::LibXML not detected, drat\n";

	print "checking if XML::XPath is present.. ";
	if ( $XML_parser = eval "use XML::XPath; 'XML::XPath'" ) {
		print "XML::XPath detected\nsetting XML parser to XML::XPath\n";

		return $XML_parser;
	}
	print "XML::XPath not found\n";

	die "XML::XPathScript needs either XML::LibXML or ",
		"XML::XPath to be installed\n";
}



sub find_module {
    return unless /\.pm$/;
    my $dest = $File::Find::name;
    $dest =~ s/lib_(axkit|tomkit)/lib/;
    $pm_files{$File::Find::name } = $dest;
}
