package Task::Dancer;

our $VERSION = '0.16';

1;

__END__

=head1 NAME

Task::Dancer - Dancer in a box

=head1 VERSION

Version 0.16

=head1 DESCRIPTION

This Task installs Dancer, optional engines, templates and assorted modules that
are not included in the Dancer core distribution.

If you've written anything relating to Dancer, please let me know.

=head1 Template Engines

=head2 L<Dancer::Template::Alloy>

=head2 L<Dancer::Template::Ctpp2>

=head2 L<Dancer::Template::HAML>

=head2 L<Dancer::Template::HtmlTemplate>

=head2 L<Dancer::Template::Mason>

=head2 L<Dancer::Template::MicroTemplate>

=head2 L<Dancer::Template::TemplateSandbox>

=head2 L<Dancer::Template::Tenjin>

=head2 L<Dancer::Template::Tiny>

=head1 Logging Engines

=head2 L<Dancer::Logger::LogHandler>

=head2 L<Dancer::Logger::PSGI>

=head2 L<Dancer::Logger::Syslog>

=head1 Session Engines

=head2 L<Dancer::Session::Cookie>

=head2 L<Dancer::Session::Memcache>

=head2 L<Dancer::Session::PSGI>

=head2 L<Dancer::Session::Storable>

=head1 Plugins

=head2 L<Dancer::Plugin::Authorize>

=head2 L<Dancer::Plugin::Database>

=head2 L<Dancer::Plugin::DBIC>

=head2 L<Dancer::Plugin::Email>

=head2 L<Dancer::Plugin::REST>

=head2 L<Dancer::Plugin::Scoped>

=head2 L<Dancer::Plugin::SiteMap>

=head2 L<Dancer::Plugin::Validation>

=head1 More Plack middlewares

=head2 L<Dancer::Debug>

=head1 AUTHOR

Sawyer X, C<< <xsawyerx at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-task-dancer at rt.cpan.org>,
or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-Dancer>.  I will be
notified, and then you'll automatically be notified of progress on your bug as I
make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::Dancer

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-Dancer>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-Dancer>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-Dancer>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-Dancer/>

=back

=head1 ACKNOWLEDGEMENTS

L<Dancer> team.

=head1 LICENSE AND COPYRIGHT

Copyright 2010 Sawyer X.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

