package Microsoft::AdCenter::ReportingService::Test::PublisherUsagePerformanceReportRequest;

use strict;
use warnings;

use base qw/Test::Class/;
use Test::More;

use Microsoft::AdCenter::ReportingService;
use Microsoft::AdCenter::ReportingService::PublisherUsagePerformanceReportRequest;

sub test_can_create_publisher_usage_performance_report_request_and_set_all_fields : Test(6) {
    my $publisher_usage_performance_report_request = Microsoft::AdCenter::ReportingService::PublisherUsagePerformanceReportRequest->new
        ->Aggregation('aggregation')
        ->Columns('columns')
        ->Filter('filter')
        ->Scope('scope')
        ->Time('time')
    ;

    ok($publisher_usage_performance_report_request);

    is($publisher_usage_performance_report_request->Aggregation, 'aggregation', 'can get aggregation');
    is($publisher_usage_performance_report_request->Columns, 'columns', 'can get columns');
    is($publisher_usage_performance_report_request->Filter, 'filter', 'can get filter');
    is($publisher_usage_performance_report_request->Scope, 'scope', 'can get scope');
    is($publisher_usage_performance_report_request->Time, 'time', 'can get time');
};

1;
