package Microsoft::AdCenter::CustomerManagementService;

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::CustomerManagementService - Service client for Microsoft AdCenter Customer Management Service.

=head1 SYNOPSIS

    use Microsoft::AdCenter::CustomerManagementService;

    my $service_client = Microsoft::AdCenter::CustomerManagementService->new
        ->Password("password");
        ->UserAccessKey("user access key")
        ->UserName("user name")

    my $response = $service_client->CustomerSignUp(
        apiFlags => ...
        user => ...
        customer => ...
        account => ...
        consentToTermsAndConditions => ...
        couponCode => ...
    );

See L<http://msdn.microsoft.com/en-US/library/ee730327%28v=MSADS.60%29.aspx> for detailed documentation for this service.

=head1 METHODS

=head2 EndPoint

Changes the end point for this service client.

Default value:
https://adcenterapi.microsoft.com/Api/Advertiser/v6/CustomerManagement/CustomerManagement.asmx

=head2 Password

Gets/sets Password (string) in the request header

=head2 UserAccessKey

Gets/sets UserAccessKey (string) in the request header

=head2 UserName

Gets/sets UserName (string) in the request header

=cut

use base qw/Microsoft::AdCenter::Service/;

sub _service_name {
    return 'CustomerManagement';
}

sub _class_name {
    return 'CustomerManagementService';
}

sub _namespace_uri {
    return 'http://adcenter.microsoft.com/syncapis';
}

sub _default_location {
    return 'https://adcenterapi.microsoft.com/Api/Advertiser/v6/CustomerManagement/CustomerManagement.asmx';
}

sub _wsdl {
    return 'https://adcenterapi.microsoft.com/Api/Advertiser/v6/CustomerManagement/CustomerManagement.asmx?wsdl';
}

our $_request_headers = [
    { name => 'ApiUserAuthHeader', type => 'ApiUserAuthHeader', namespace => 'http://adcenter.microsoft.com/syncapis' }
];

our $_request_headers_expanded = {
    Password => 'string',
    UserAccessKey => 'string',
    UserName => 'string'
};

sub _request_headers {
    return $_request_headers;
}

sub _request_headers_expanded {
    return $_request_headers_expanded;
}

our $_response_headers = [
];

our $_response_headers_expanded = {
};

sub _response_headers {
    return $_response_headers;
}

sub _response_headers_expanded {
    return $_response_headers_expanded;
}

=head2 CustomerSignUp

Parameters:
  apiFlags (int)
  user (AdCenterUser)
  customer (AdCenterCustomer)
  account (AdCenterAccount)
  consentToTermsAndConditions (boolean)
  couponCode (string)

Returns:
  CustomerSignUpResponse

=cut

sub CustomerSignUp {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/CustomerSignUp',
        request => {
            name => 'CustomerSignUp',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'user', type => 'AdCenterUser', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'customer', type => 'AdCenterCustomer', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'account', type => 'AdCenterAccount', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'consentToTermsAndConditions', type => 'boolean', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'couponCode', type => 'string', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'CustomerSignUpResponse'
        },
        parameters => \%args
    );
}

=head2 GetAccountBillingInfo

Parameters:
  apiFlags (int)
  accountId (int)
  customerId (int)
  userId (int)
  activityDays (int)

Returns:
  GetAccountBillingInfoResponse

=cut

sub GetAccountBillingInfo {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetAccountBillingInfo',
        request => {
            name => 'GetAccountBillingInfo',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'accountId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'customerId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'userId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'activityDays', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetAccountBillingInfoResponse'
        },
        parameters => \%args
    );
}

=head2 GetAccounts

Parameters:
  APIFlags (int)

Returns:
  GetAccountsResponse

=cut

sub GetAccounts {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetAccounts',
        request => {
            name => 'GetAccounts',
            parameters => [
                { name => 'APIFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetAccountsResponse'
        },
        parameters => \%args
    );
}

=head2 GetAccountsByIds

Parameters:
  APIFlags (int)
  accountIds (ArrayOfInt)

Returns:
  GetAccountsByIdsResponse

=cut

sub GetAccountsByIds {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetAccountsByIds',
        request => {
            name => 'GetAccountsByIds',
            parameters => [
                { name => 'APIFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'accountIds', type => 'ArrayOfInt', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetAccountsByIdsResponse'
        },
        parameters => \%args
    );
}

=head2 GetCardInvoice

Parameters:
  apiFlags (int)
  customerId (int)
  userId (int)
  handle (AdCenterCardInvoiceHandle)

Returns:
  GetCardInvoiceResponse

=cut

sub GetCardInvoice {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetCardInvoice',
        request => {
            name => 'GetCardInvoice',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'customerId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'userId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'handle', type => 'AdCenterCardInvoiceHandle', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetCardInvoiceResponse'
        },
        parameters => \%args
    );
}

=head2 GetCustomer

Parameters:
  apiFlags (int)
  customerId (int)

Returns:
  GetCustomerResponse

=cut

sub GetCustomer {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetCustomer',
        request => {
            name => 'GetCustomer',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'customerId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetCustomerResponse'
        },
        parameters => \%args
    );
}

=head2 GetPaymentInstrument

Parameters:
  apiFlags (int)
  accountId (int)

Returns:
  GetPaymentInstrumentResponse

=cut

sub GetPaymentInstrument {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/GetPaymentInstrument',
        request => {
            name => 'GetPaymentInstrument',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'accountId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'GetPaymentInstrumentResponse'
        },
        parameters => \%args
    );
}

=head2 UpdateCustomer

Parameters:
  apiFlags (int)
  customer (AdCenterCustomer)

Returns:
  UpdateCustomerResponse

=cut

sub UpdateCustomer {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/UpdateCustomer',
        request => {
            name => 'UpdateCustomer',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'customer', type => 'AdCenterCustomer', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'UpdateCustomerResponse'
        },
        parameters => \%args
    );
}

=head2 UpdatePaymentInstrument

Parameters:
  apiFlags (int)
  accountId (int)
  creditCard (AdCenterCreditCard)

Returns:
  UpdatePaymentInstrumentResponse

=cut

sub UpdatePaymentInstrument {
    my ($self, %args) = @_;
    return $self->_invoke(
        soap_action => 'http://adcenter.microsoft.com/syncapis/UpdatePaymentInstrument',
        request => {
            name => 'UpdatePaymentInstrument',
            parameters => [
                { name => 'apiFlags', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'accountId', type => 'int', namespace => 'http://adcenter.microsoft.com/syncapis' },
                { name => 'creditCard', type => 'AdCenterCreditCard', namespace => 'http://adcenter.microsoft.com/syncapis' }
            ]
        },
        response => {
            name => 'UpdatePaymentInstrumentResponse'
        },
        parameters => \%args
    );
}

our %_simple_types = (
    AccountStatus => 'http://adcenter.microsoft.com/syncapis',
    CountryCode => 'http://adcenter.microsoft.com/syncapis',
    CreditCardType => 'http://adcenter.microsoft.com/syncapis',
    Currency => 'http://adcenter.microsoft.com/syncapis',
    CurrencyType => 'http://adcenter.microsoft.com/syncapis',
    EmailFormat => 'http://adcenter.microsoft.com/syncapis',
    ErrorLevel => 'http://adcenter.microsoft.com/syncapis',
    Industry => 'http://adcenter.microsoft.com/syncapis',
    LCID => 'http://adcenter.microsoft.com/syncapis',
    LanguageType => 'http://adcenter.microsoft.com/syncapis',
    Market => 'http://adcenter.microsoft.com/syncapis',
    PaymentOption => 'http://adcenter.microsoft.com/syncapis',
    ResultStatus => 'http://adcenter.microsoft.com/syncapis',
    SecretQuestions => 'http://adcenter.microsoft.com/syncapis',
);

sub _simple_types {
    return %_simple_types;
}

our @_complex_types = (qw/
    AdCenterAccount
    AdCenterAddress
    AdCenterCardBillingStatement
    AdCenterCardBillingStatementEntry
    AdCenterCardInvoice
    AdCenterCardInvoiceEntry
    AdCenterCardInvoiceHandle
    AdCenterCardInvoiceHeader
    AdCenterContactInfo
    AdCenterCreditCard
    AdCenterCustomer
    AdCenterPaymentInstrument
    AdCenterSap
    AdCenterStatementEntry
    AdCenterUser
    ApiUserAuthHeader
    CardInvoiceResponseMsg
    CreditCardInfoUpdateResponseMsg
    CustomerSignUpResponse
    CustomerSignUpResponseMsg
    CustomerUpdateResponseMsg
    ErrorInfo
    GetAccountBillingInfoResponse
    GetAccountBillingInfoResponseMsg
    GetAccountsByIdsResponse
    GetAccountsResponse
    GetCardInvoiceResponse
    GetCreditCardInfoResponseMsg
    GetCustomerResponse
    GetCustomerResponseMsg
    GetPaymentInstrumentResponse
    OperationResult
    ResponseMsg
    UpdateCustomerResponse
    UpdatePaymentInstrumentResponse
/);

sub _complex_types {
    return @_complex_types;
}

our %_array_types = (
    ArrayOfAdCenterAccount => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'AdCenterAccount',
        element_type => 'AdCenterAccount'
    },
    ArrayOfAdCenterCardBillingStatementEntry => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'AdCenterCardBillingStatementEntry',
        element_type => 'AdCenterCardBillingStatementEntry'
    },
    ArrayOfAdCenterCardInvoiceEntry => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'AdCenterCardInvoiceEntry',
        element_type => 'AdCenterCardInvoiceEntry'
    },
    ArrayOfAdCenterCreditCard => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'AdCenterCreditCard',
        element_type => 'AdCenterCreditCard'
    },
    ArrayOfErrorInfo => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'ErrorInfo',
        element_type => 'ErrorInfo'
    },
    ArrayOfInt => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'int',
        element_type => 'int'
    },
    ArrayOfString => {
        namespace_uri => 'http://adcenter.microsoft.com/syncapis',
        element_name => 'string',
        element_type => 'string'
    },
);

sub _array_types {
    return %_array_types;
}

__PACKAGE__->mk_accessors(qw/
    EndPoint
    Password
    UserAccessKey
    UserName
/);

1;
