use v6;

#
# This program creates metrics modules for some fonts and place them
# under the "Metrics" directory.
#
# Author: Gisle Aas
# Perl 5 -> Raku Port: David Warring

BEGIN %*ENV<METRICS> //= 'etc/Core14_AFMs';

use lib '.';
use Font::AFM;

class Build {

    method !build-metrics {

        BEGIN our @CoreFonts = <
            Courier      Courier-Bold     Courier-Oblique    Courier-BoldOblique
            Helvetica    Helvetica-Bold   Helvetica-Oblique  Helvetica-BoldOblique
            Times-Roman  Times-Bold       Times-Italic       Times-BoldItalic
            Symbol       ZapfDingbats
        >;

        for @CoreFonts -> $name {
            my Str $class-name = Font::AFM.class-name( $name );
            my Str @parts = $class-name.split('::');
            my Str $mod-name = @parts.pop;
            my $lib-dir = $*SPEC.catdir('lib', @parts);
            mkdir( $lib-dir, 0o755)
                unless $lib-dir.IO ~~ :e;

            my $afm = Font::AFM.new: :$name;

            say "Building $name => $class-name";
            {
                my $gen-path = $*SPEC.catfile($lib-dir, "$mod-name.rakumod");
                my $*OUT = open( $gen-path, :w);

                print q:s:c:to"--CODE-GEN--";
                use v6;
                # Font metrics for $name
                #
                # DO NOT EDIT!!!
                #
                # This file was auto-generated by {$*SPEC.abs2rel($?FILE)} based on the AFM file for the font.
                #
                # {$afm.Notice}

                --CODE-GEN--
                print $afm.raku-gen: :name($class-name);
            }
        }
    }

    method build($where) {
        self!build-metrics();
    }
}

sub MAIN(:$indir = '.', :$metrics-path?, :$glyphs-path ) {

    %*ENV<METRICS> = $metrics-path
        if $metrics-path.defined;

    Build.new.build($indir);
}
