#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/ErrorLoggerTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Role-ErrorLogger.
#
#   perl-Dist-Zilla-Role-ErrorLogger is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Role-ErrorLogger is distributed in the hope that it will be useful, but WITHOUT
#   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Role-ErrorLogger. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package ErrorLoggerTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'PluginTester';

use Test::More;

has hook => (
    is          => 'ro',
    isa         => 'CodeRef',
    default     => sub {},
);

sub _build_plugin { '=ErrorLoggerTestPlugin' };

sub _build_ini_body {
    my ( $self ) = @_;
    return [
        'GatherDir',
        $self->plugin,
    ];
};

around build => sub {
    my ( $orig, $self ) = @_;
    local $ErrorLoggerTestPlugin::Hook = $self->hook;
    return $self->$orig();
};

sub check {
    my ( $self ) = @_;
};

1;

# end of file #
