#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/TemplatesTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Templates.
#
#   perl-Dist-Zilla-Plugin-Templates is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Templates is distributed in the hope that it will be useful, but WITHOUT
#   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Templates. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package TemplatesTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'Test::Dist::Zilla::Build';

use Test::More;
use Test::Deep qw{ cmp_deeply };
use Path::Tiny;

has options => (
    isa         => 'HashRef',
    is          => 'ro',
    default     => sub { {} },
);

sub _build_plugins {
    my ( $self ) = @_;
    return [
        'GatherDir',
        [ 'Templates' => $self->options ],
    ];
};

sub _build_message_filter {
    return sub {
        map(
            { ( my $r = $_ ) =~ s{^\[[^\[\]]*\] }{}; $r; }
            grep( { $_ =~ m{^\[Templates\] } } @_ )
        );
    };
};

test 'Files' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    if ( not exists( $self->expected->{ files } ) ) {
        plan skip_all => 'no expected files specified';
    };
    my @names = keys( %{ $self->expected->{ files } } );
    my $built_in = path( $self->tzil->built_in );
    plan 'no_plan';
    for my $name ( @names ) {
        my $exp = $self->expected->{ files }->{ $name };
        my $file = $built_in->child( $name );
        if ( defined( $exp ) ) {
            ok( $file->exists, "$name exists" ) and do {
                my $act = ref( $exp ) ? (
                    [ $file->lines_utf8( { chomp => 1 } ) ]
                ) : (
                    $file->slurp_utf8()
                );
                cmp_deeply( $act, $exp, "$name content" ) or do {
                    $self->_anno_text( $name, ref( $act ) ? @$act : $act );
                };
            };
        } else {
            ok( ! $file->exists, "$name not exist" );
        };
    };
};

1;

# end of file #
