#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/MetaResourcesTemplateTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-MetaResources-Template.
#
#   perl-Dist-Zilla-Plugin-MetaResources-Template is free software: you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-MetaResources-Template is distributed in the hope that it will be
#   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-MetaResources-Template. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package MetaResourcesTemplateTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'PluginTester';

use Test::More;
use Test::Deep qw{ cmp_deeply };

sub build_plugin { 'MetaResources::Template' };

#   `MetaResources::Template` plugin options, in form acceptable by `Builder->from_config`.
has resources => (
    is          => 'ro',
    isa         => 'HashRef',
    required    => 1,
);

#   Expected resources, in form returned by `$tzil->distmeta->{ resources }`.
has exp_resources => (
    is          => 'ro',
    isa         => 'HashRef',
    required    => 0,
);

sub build_ini_body {
    my ( $self ) = @_;
    return [
        'GatherDir',
        'Manifest',
        'MetaYAML',
        [ 'MetaResources::Template', $self->resources ],
    ];
};

test 'check text' => sub {
    my ( $self ) = @_;
    if ( $self->exp_exception ) {
        plan skip_all => 'exception occurred, nothing to check';
    }
    my $resources = $self->tzil->distmeta->{ resources };
    cmp_deeply( $resources, $self->exp_resources, 'resources' ) or do {
        $self->anno();
    };
};

1;

# end of file #
