package Minilla::ModuleMaker::ExtUtilsMakeMaker;
use strict;
use warnings;
use utf8;
use Data::Section::Simple qw(get_data_section);
use Text::MicroTemplate qw(render_mt);
use Data::Dumper;
use File::Spec::Functions qw(catdir rel2abs);
use File::Find ();
use TAP::Harness::Env;

# This module is EXPERIMENTAL.
# You can use this. But I may change the behaviour...

use Moo;

no Moo;

use Minilla::Util qw(spew_raw);

sub generate {
    my ($self, $project) = @_;

    local $Data::Dumper::Terse = 1;
    local $Data::Dumper::Useqq = 1;
    local $Data::Dumper::Purity = 1;
    local $Data::Dumper::Indent = 0;
    local $Data::Dumper::Sortkeys = 1;
    my $content = get_data_section('Makefile.PL');
    my $mt = Text::MicroTemplate->new(template => $content, escape_func => sub { $_[0] });
    my $src = $mt->build->($project);
    spew_raw('Makefile.PL', $src);
}

sub prereqs {
    my ($self, $project) = @_;

    my %configure_requires = (
        'ExtUtils::MakeMaker' => '6.64', # TEST_REQUIRES
    );

    my $prereqs = +{
        configure => {
            requires => {
                %configure_requires,
            }
        }
    };

    for my $key (qw(tap_harness_args use_xsutil c_source allow_pureperl requires_external_bin)) {
        if( $project->$key ){
            die "$key does not supported by " . __PACKAGE__;
        }
    }
    return $prereqs;
}

sub run_tests {
    my $harness = TAP::Harness::Env->create({
        verbosity => 0,
        lib       => [ map { rel2abs(catdir(qw/blib/, $_)) } qw/arch lib/ ],
        color     => -t STDOUT
    });
    my @tests = sort +_find(qr/\.t$/, 't');
    if ($ENV{RELEASE_TESTING}) {
        push @tests, sort +_find(qr/\.t$/, 'xt');
    }
    $harness->runtests(@tests)->has_errors and die;
}

sub _find {
    my ($pattern, $dir) = @_;
    my @ret;
    File::Find::find(sub { push @ret, $File::Find::name if /$pattern/ && -f }, $dir) if -d $dir;
    return @ret;
}

1;
__DATA__

@@ Makefile.PL
? my $project = shift;
? use Data::Dumper;
# =========================================================================
# THIS FILE IS AUTOMATICALLY GENERATED BY MINILLA.
# DO NOT EDIT DIRECTLY.
# =========================================================================

use 5.008_001;
use strict;

use ExtUtils::MakeMaker;

? if ( @{ $project->requires_external_bin || [] } ) {
use Devel::CheckBin;

?   for my $bin ( @{ $project->requires_external_bin } ) {
check_bin('<?= $bin ?>');
?   }

? }

use File::Copy;

print "cp META.json MYMETA.json\n";
copy("META.json","MYMETA.json") or die "Copy failed(META.json): $!";

if (-f 'META.yml') {
    print "cp META.yml MYMETA.yml\n";
    copy("META.yml","MYMETA.yml") or die "Copy failed(META.yml): $!";
} else {
    print "There is no META.yml... You may install this module from the repository...\n";
}

? my $prereqs = $project->cpan_meta->effective_prereqs;
? my $d = sub { Dumper($prereqs->merged_requirements([$_[0]])->as_string_hash) };
my %args;
if ($ExtUtils::MakeMaker::VERSION >= 6.64) {
    # *_REQUIRES was supported.

    $args{CONFIGURE_REQUIRES} = <?= $d->('configure') ?>;
    $args{BUILD_REQUIRES}     = <?= $d->('build') ?>;
    $args{TEST_REQUIRES}      = <?= $d->('test') ?>;
    $args{PREREQ_PM}          = <?= $d->('runtime') ?>;
} else {
    $args{PREREQ_PM}          = <?= Dumper($prereqs->merged_requirements([qw(configure build runtime test)])->as_string_hash) ?>;
}

if ($ExtUtils::MakeMaker::VERSION >= 6.57_01) {
    $args{NO_MYMETA} = 1;
}

WriteMakefile(
    NAME     => '<?= $project->name ?>',
    DISTNAME => '<?= $project->dist_name ?>',
    VERSION  => '<?= $project->version ?>',
    %args,
);
