/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIntHash;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntObjectHashMap
extends TIntHash
implements Serializable {
    protected transient Object[] _values;

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(int key, Object value) {
        Object previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        Object[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public Object get(int key) {
        int index = this.index(key);
        return index < 0 ? null : this._values[index];
    }

    public void clear() {
        super.clear();
        int[] keys = this._set;
        Object[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = null;
            states[i] = 0;
        }
    }

    public Object remove(int key) {
        Object prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap that = (TIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = null;
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(Object val) {
        byte[] states = this._states;
        Object[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        return this.contains(key);
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        byte[] states = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure procedure) {
        byte[] states = this._states;
        int[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction function) {
        byte[] states = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TIntObjectProcedure {
            IOException e;
            private final /* synthetic */ TIntObjectHashMap this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(int key, Object value) {
                try {
                    this.val$stream.writeInt(key);
                    this.val$stream.writeObject(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(TIntObjectHashMap this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TIntObjectHashMap tIntObjectHashMap) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int key = stream.readInt();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    public TIntObjectHashMap() {
    }

    public TIntObjectHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    private static final class EqProcedure
    implements TIntObjectProcedure {
        private final TIntObjectHashMap _otherMap;

        public final boolean execute(int key, Object value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }

        EqProcedure(TIntObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }
    }
}

