/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.OutputStreamFactory;
import org.apache.tika.batch.ParserFactory;
import org.apache.tika.batch.fs.AbstractFSConsumer;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ContentHandlerFactory;
import org.xml.sax.ContentHandler;

public class BasicTikaFSConsumer
extends AbstractFSConsumer {
    private boolean parseRecursively = true;
    private final ParserFactory parserFactory;
    private final ContentHandlerFactory contentHandlerFactory;
    private final OutputStreamFactory fsOSFactory;
    private final TikaConfig config;
    private String outputEncoding = StandardCharsets.UTF_8.toString();

    public BasicTikaFSConsumer(ArrayBlockingQueue<FileResource> queue, ParserFactory parserFactory, ContentHandlerFactory contentHandlerFactory, OutputStreamFactory fsOSFactory, TikaConfig config) {
        super(queue);
        this.parserFactory = parserFactory;
        this.contentHandlerFactory = contentHandlerFactory;
        this.fsOSFactory = fsOSFactory;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processFileResource(FileResource fileResource) {
        ContentHandler handler;
        OutputStream os;
        Parser parser = this.parserFactory.getParser(this.config);
        ParseContext context = new ParseContext();
        if (this.parseRecursively) {
            context.set(Parser.class, parser);
        }
        if ((os = this.getOutputStream(this.fsOSFactory, fileResource)) == null) {
            LOG.debug("Skipping: {}", (Object)fileResource.getMetadata().get(FSProperties.FS_REL_PATH));
            return false;
        }
        InputStream is = this.getInputStream(fileResource);
        if (is == null) {
            IOUtils.closeQuietly(os);
            return false;
        }
        try {
            handler = this.contentHandlerFactory.getNewContentHandler(os, this.getOutputEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.incrementHandledExceptions();
            LOG.error(this.getXMLifiedLogMsg("output_encoding_ex", fileResource.getResourceId(), e, new String[0]));
            this.flushAndClose(os);
            throw new RuntimeException(e);
        }
        Throwable thrown = null;
        try {
            this.parse(fileResource.getResourceId(), parser, is, handler, fileResource.getMetadata(), context);
        }
        catch (Error t) {
            throw t;
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            this.flushAndClose(os);
        }
        return thrown == null;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }
}

