/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.DerivedMap;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.resources.Errors;

public final class Containers
extends Static {
    private Containers() {
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @SafeVarargs
    public static <E> List<? extends E> unmodifiableList(E ... EArray) {
        return UnmodifiableArrayList.wrap(EArray);
    }

    public static <E> List<? extends E> unmodifiableList(E[] EArray, int n, int n2) {
        ArgumentChecks.ensureNonNull("array", EArray);
        ArgumentChecks.ensureValidIndexRange(EArray.length, n, n2);
        return UnmodifiableArrayList.wrap(EArray, n, n2);
    }

    public static <S, E> Set<E> derivedSet(Set<S> set, ObjectConverter<S, E> objectConverter) {
        ArgumentChecks.ensureNonNull("converter", objectConverter);
        if (set == null) {
            return null;
        }
        return DerivedSet.create(set, objectConverter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
        ArgumentChecks.ensureNonNull("keyConverter", objectConverter);
        ArgumentChecks.ensureNonNull("valueConverter", objectConverter2);
        if (map == null) {
            return null;
        }
        return DerivedMap.create(map, objectConverter, objectConverter2);
    }

    public static <T> T property(Map<?, ?> map, Object object, Class<T> clazz) throws IllegalArgumentException {
        if (map == null) {
            return null;
        }
        Object obj = map.get(object);
        if (obj != null && !clazz.isInstance(obj)) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)59, object, clazz, obj.getClass()));
        }
        return (T)obj;
    }

    public static int hashMapCapacity(int n) {
        int n2 = n >>> 2;
        if ((n & 3) != 0) {
            ++n2;
        }
        return n + n2;
    }
}

