/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;

public final class PDFToImage {
    private static final String PASSWORD = "-password";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String PAGE = "-page";
    private static final String IMAGE_TYPE = "-imageType";
    private static final String FORMAT = "-format";
    private static final String OUTPUT_PREFIX = "-outputPrefix";
    private static final String PREFIX = "-prefix";
    private static final String COLOR = "-color";
    private static final String RESOLUTION = "-resolution";
    private static final String DPI = "-dpi";
    private static final String CROPBOX = "-cropbox";
    private static final String TIME = "-time";

    private PDFToImage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        int dpi;
        try {
            Class.forName("sun.java2d.cmm.kcms.KcmsServiceProvider");
            System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.setProperty("apple.awt.UIElement", "true");
        String password = "";
        String pdfFile = null;
        String outputPrefix = null;
        String imageFormat = "jpg";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        String color = "rgb";
        float cropBoxLowerLeftX = 0.0f;
        float cropBoxLowerLeftY = 0.0f;
        float cropBoxUpperRightX = 0.0f;
        float cropBoxUpperRightY = 0.0f;
        boolean showTime = false;
        try {
            dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException e) {
            dpi = 96;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(PAGE)) {
                if (++i >= args.length) {
                    PDFToImage.usage();
                }
                startPage = Integer.parseInt(args[i]);
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(IMAGE_TYPE) || args[i].equals(FORMAT)) {
                imageFormat = args[++i];
                continue;
            }
            if (args[i].equals(OUTPUT_PREFIX) || args[i].equals(PREFIX)) {
                outputPrefix = args[++i];
                continue;
            }
            if (args[i].equals(COLOR)) {
                color = args[++i];
                continue;
            }
            if (args[i].equals(RESOLUTION) || args[i].equals(DPI)) {
                dpi = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals(CROPBOX)) {
                cropBoxLowerLeftX = Float.valueOf(args[++i]).floatValue();
                cropBoxLowerLeftY = Float.valueOf(args[++i]).floatValue();
                cropBoxUpperRightX = Float.valueOf(args[++i]).floatValue();
                cropBoxUpperRightY = Float.valueOf(args[++i]).floatValue();
                continue;
            }
            if (args[i].equals(TIME)) {
                showTime = true;
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PDFToImage.usage();
        } else {
            if (outputPrefix == null) {
                outputPrefix = pdfFile.substring(0, pdfFile.lastIndexOf(46));
            }
            PDDocument document = null;
            try {
                document = PDDocument.load(new File(pdfFile), password);
                ImageType imageType = null;
                if ("bilevel".equalsIgnoreCase(color)) {
                    imageType = ImageType.BINARY;
                } else if ("gray".equalsIgnoreCase(color)) {
                    imageType = ImageType.GRAY;
                } else if ("rgb".equalsIgnoreCase(color)) {
                    imageType = ImageType.RGB;
                } else if ("rgba".equalsIgnoreCase(color)) {
                    imageType = ImageType.ARGB;
                }
                if (imageType == null) {
                    System.err.println("Error: Invalid color.");
                    System.exit(2);
                }
                if (cropBoxLowerLeftX != 0.0f || cropBoxLowerLeftY != 0.0f || cropBoxUpperRightX != 0.0f || cropBoxUpperRightY != 0.0f) {
                    PDFToImage.changeCropBox(document, cropBoxLowerLeftX, cropBoxLowerLeftY, cropBoxUpperRightX, cropBoxUpperRightY);
                }
                long startTime = System.nanoTime();
                boolean success = true;
                endPage = Math.min(endPage, document.getNumberOfPages());
                PDFRenderer renderer = new PDFRenderer(document);
                for (int i = startPage - 1; i < endPage; ++i) {
                    BufferedImage image = renderer.renderImageWithDPI(i, dpi, imageType);
                    String fileName = outputPrefix + (i + 1) + "." + imageFormat;
                    success &= ImageIOUtil.writeImage(image, fileName, dpi);
                }
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                int count = 1 + endPage - startPage;
                if (showTime) {
                    System.err.printf("Rendered %d page%s in %dms\n", count, count == 1 ? "" : "s", duration / 1000000L);
                }
                if (!success) {
                    System.err.println("Error: no writer found for image format '" + imageFormat + "'");
                    System.exit(1);
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar PDFToImage [options] <inputfile>\n\nOptions:\n  -password  <password>            : Password to decrypt document\n  -format <string>                 : Image format: " + PDFToImage.getImageFormats() + "\n  -prefix <string>                 : Filename prefix for image files\n  -page <number>                   : The only page to extract (1-based)\n  -startPage <int>                 : The first page to start extraction (1-based)\n  -endPage <int>                   : The last page to extract(inclusive)\n  -color <int>                     : The color depth (valid: bilevel, gray, rgb, rgba)\n  -dpi <int>                       : The DPI of the output image\n  -cropbox <int> <int> <int> <int> : The page area to export\n  -time                            : Prints timing information to stdout\n  <inputfile>                      : The PDF document to use\n";
        System.err.println(message);
        System.exit(1);
    }

    private static String getImageFormats() {
        StringBuilder retval = new StringBuilder();
        String[] formats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].equalsIgnoreCase(formats[i])) continue;
            retval.append(formats[i]);
            if (i + 1 >= formats.length) continue;
            retval.append(", ");
        }
        return retval.toString();
    }

    private static void changeCropBox(PDDocument document, float a, float b, float c, float d) {
        for (PDPage page : document.getPages()) {
            System.out.println("resizing page");
            PDRectangle rectangle = new PDRectangle();
            rectangle.setLowerLeftX(a);
            rectangle.setLowerLeftY(b);
            rectangle.setUpperRightX(c);
            rectangle.setUpperRightY(d);
            page.setCropBox(rectangle);
        }
    }
}

