/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.Comparator;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIteratorWrapper;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;

public abstract class FSLeafIndexImpl<T extends FeatureStructure>
implements Comparator<T>,
IntComparator,
FSIndexImpl {
    private final int indexType;
    protected final CASImpl lowLevelCAS;
    private static final int STRING_CODE = 0;
    private static final int FLOAT_CODE = 1;
    private static final int INT_CODE = 2;
    private static final int TYPE_ORDER_CODE = 3;
    private static final int BOOLEAN_CODE = 4;
    private static final int BYTE_CODE = 5;
    private static final int SHORT_CODE = 6;
    private static final int LONG_CODE = 7;
    private static final int DOUBLE_CODE = 8;
    private FSIndexComparatorImpl comparator;
    private boolean isInitialized = false;
    private int[] keyType;
    private int[] keyOffset;
    private LinearTypeOrder[] typeOrder;
    private int[] keyComp;
    private int numKeys;
    private final Type type;
    private final int typeCode;

    public String toString() {
        String kind;
        switch (this.indexType) {
            case 0: {
                kind = "Sorted";
                break;
            }
            case 1: {
                kind = "Set";
                break;
            }
            case 2: {
                kind = "Bag";
                break;
            }
            case 3: {
                kind = "Default Bag";
                break;
            }
            default: {
                kind = "Invalid";
            }
        }
        return "FSLeafIndexImpl [type=" + this.type + ", kind=" + kind + "]";
    }

    private FSLeafIndexImpl() {
        this.indexType = 0;
        this.lowLevelCAS = null;
        this.type = null;
        this.typeCode = 0;
    }

    protected FSLeafIndexImpl(CASImpl cas, Type type, int indexType) {
        this.indexType = indexType;
        this.lowLevelCAS = cas;
        this.type = type;
        this.typeCode = ((TypeImpl)type).getCode();
    }

    abstract boolean insert(int var1);

    abstract boolean insert(int var1, int var2);

    abstract boolean remove(int var1);

    public abstract ComparableIntPointerIterator<T> pointerIterator(IntComparator var1, int[] var2, int var3);

    @Override
    public FSIndexComparator getComparator() {
        return this.comparator;
    }

    IntComparator getIntComparator() {
        return this;
    }

    public int getIndexingStrategy() {
        return this.indexType;
    }

    boolean init(FSIndexComparator comp) {
        if (this.isInitialized) {
            return false;
        }
        FSIndexComparatorImpl comp1 = (FSIndexComparatorImpl)comp;
        this.comparator = comp1.copy();
        if (!this.comparator.isValid()) {
            return false;
        }
        int nKeys = this.comparator.getNumberOfKeys();
        this.keyType = new int[nKeys];
        this.keyOffset = new int[nKeys];
        this.keyComp = new int[nKeys];
        this.typeOrder = new LinearTypeOrder[nKeys];
        block4: for (int i = 0; i < nKeys; ++i) {
            switch (comp.getKeyType(i)) {
                case 0: {
                    Feature keyFeature = this.comparator.getKeyFeature(i);
                    this.keyType[i] = FSLeafIndexImpl.getKeyCode(keyFeature);
                    this.keyOffset[i] = this.getFeatureOffset(keyFeature);
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    continue block4;
                }
                case 1: {
                    this.keyType[i] = 3;
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    this.typeOrder[i] = this.comparator.getKeyTypeOrder(i);
                    this.keyOffset[i] = 0;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Assertion failed.");
                }
            }
        }
        this.numKeys = nKeys;
        this.isInitialized = true;
        return true;
    }

    private static final int getKeyCode(Feature feat) {
        String typeName = feat.getRange().getName();
        if (typeName.equals("uima.cas.String")) {
            return 0;
        }
        if (typeName.equals("uima.cas.Float")) {
            return 1;
        }
        if (typeName.equals("uima.cas.Boolean")) {
            return 4;
        }
        if (typeName.equals("uima.cas.Byte")) {
            return 5;
        }
        if (typeName.equals("uima.cas.Short")) {
            return 6;
        }
        if (typeName.equals("uima.cas.Long")) {
            return 7;
        }
        if (typeName.equals("uima.cas.Double")) {
            return 8;
        }
        return 2;
    }

    private final int getFeatureOffset(Feature feat) {
        return this.comparator.getLowLevelCAS().getFeatureOffset(((FeatureImpl)feat).getCode());
    }

    @Override
    public int ll_compare(int fs1, int fs2) {
        return this.compare(fs1, fs2);
    }

    @Override
    public int compare(int fs1, int fs2) {
        int[] heap = this.lowLevelCAS.getHeap().heap;
        int[] localKeyType = this.keyType;
        int[] localKeyOffset = this.keyOffset;
        int[] localKeyComp = this.keyComp;
        int localNumKeys = this.numKeys;
        block7: for (int i = 0; i < localNumKeys; ++i) {
            int val1 = heap[fs1 + localKeyOffset[i]];
            int val2 = heap[fs2 + localKeyOffset[i]];
            switch (localKeyType[i]) {
                case 0: {
                    String string1 = this.lowLevelCAS.getStringForCode(val1);
                    String string2 = this.lowLevelCAS.getStringForCode(val2);
                    int compVal = string1 == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string1.compareTo(string2));
                    if (compVal == 0) continue block7;
                    if (localKeyComp[i] == 0) {
                        return compVal;
                    }
                    return -compVal;
                }
                case 1: {
                    float float1 = CASImpl.int2float(val1);
                    float float2 = CASImpl.int2float(val2);
                    if (float1 < float2) {
                        if (localKeyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (!(float1 > float2)) continue block7;
                    if (localKeyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 3: {
                    if (val1 == val2) continue block7;
                    if (this.typeOrder[i].lessThan(val1, val2)) {
                        if (localKeyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (localKeyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 7: {
                    long long1 = this.lowLevelCAS.getLongHeap().getHeapValue(val1);
                    long long2 = this.lowLevelCAS.getLongHeap().getHeapValue(val2);
                    if (long1 < long2) {
                        if (localKeyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (long1 <= long2) continue block7;
                    if (localKeyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 8: {
                    double double1 = Double.longBitsToDouble(this.lowLevelCAS.getLongHeap().getHeapValue(val1));
                    double double2 = Double.longBitsToDouble(this.lowLevelCAS.getLongHeap().getHeapValue(val2));
                    if (double1 < double2) {
                        if (localKeyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (!(double1 > double2)) continue block7;
                    if (localKeyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                default: {
                    if (val1 < val2) {
                        if (localKeyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (val1 <= val2) continue block7;
                    if (localKeyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
            }
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.comparator == null ? 0 : this.comparator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FSLeafIndexImpl other = (FSLeafIndexImpl)obj;
        return !(this.comparator == null ? other.comparator != null : !this.comparator.equals(other.comparator));
    }

    @Override
    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return this.compare(((FeatureStructureImpl)fs1).getAddress(), ((FeatureStructureImpl)fs2).getAddress());
    }

    public Type getType() {
        return this.type;
    }

    int getTypeCode() {
        return this.typeCode;
    }

    protected abstract IntPointerIterator refIterator();

    @Override
    public IntPointerIterator getIntIterator() {
        return this.refIterator();
    }

    protected abstract void bulkAddTo(IntVector var1);

    protected abstract IntPointerIterator refIterator(int var1);

    public FSIterator<T> iterator(FeatureStructure fs) {
        return new FSIteratorWrapper(this.refIterator(((FeatureStructureImpl)fs).getAddress()), this.lowLevelCAS);
    }

    public abstract void deleteFS(FeatureStructure var1);

    @Override
    public LowLevelIterator ll_iterator(boolean ambiguous) {
        if (ambiguous) {
            return this.ll_iterator();
        }
        return null;
    }

    @Override
    public LowLevelIterator ll_rootIterator() {
        return this.ll_iterator();
    }
}

