/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.PositionalAccuracyConstant;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlType(name="ConcatenatedOperationType")
@XmlRootElement(name="ConcatenatedOperation")
final class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private List<SingleOperation> operations;

    public DefaultConcatenatedOperation(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        super(map);
        ArgumentChecks.ensureNonNull("operations", coordinateOperationArray);
        if (coordinateOperationArray.length < 2) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)128, 2, CoordinateOperation.class));
        }
        this.initialize(map, coordinateOperationArray, mathTransformFactory);
        this.checkDimensions(map);
    }

    private void initialize(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        ArrayList<CoordinateOperation> arrayList = new ArrayList<CoordinateOperation>(coordinateOperationArray.length);
        CoordinateReferenceSystem coordinateReferenceSystem = this.initialize(map, coordinateOperationArray, arrayList, mathTransformFactory, this.sourceCRS == null, this.coordinateOperationAccuracy == null, this.domainOfValidity == null);
        if (this.targetCRS == null) {
            this.targetCRS = coordinateReferenceSystem;
        }
        this.operations = UnmodifiableArrayList.wrap(arrayList.toArray(new SingleOperation[arrayList.size()]));
    }

    private CoordinateReferenceSystem initialize(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, List<CoordinateOperation> list, MathTransformFactory mathTransformFactory, boolean bl, boolean bl2, boolean bl3) throws FactoryException {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        for (int i = 0; i < coordinateOperationArray.length; ++i) {
            Extent extent;
            int n;
            int n2;
            CoordinateOperation coordinateOperation = coordinateOperationArray[i];
            ArgumentChecks.ensureNonNullElement("operations", i, coordinateOperation);
            CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getSourceCRS();
            if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null && (n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension()) != (n = coordinateReferenceSystem2.getCoordinateSystem().getDimension())) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)81, "operations[" + i + "].sourceCRS", n2, n));
            }
            if (bl) {
                bl = false;
                this.sourceCRS = coordinateReferenceSystem2;
            }
            coordinateReferenceSystem = coordinateOperation.getTargetCRS();
            MathTransform mathTransform = coordinateOperation.getMathTransform();
            if (coordinateOperation instanceof ConcatenatedOperation) {
                List<SingleOperation> list2 = ((ConcatenatedOperation)coordinateOperation).getOperations();
                CoordinateOperation[] coordinateOperationArray2 = list2.toArray(new CoordinateOperation[list2.size()]);
                this.initialize(map, coordinateOperationArray2, list, mathTransform == null ? mathTransformFactory : null, false, bl2, bl3);
            } else if (!mathTransform.isIdentity()) {
                list.add(coordinateOperation);
            }
            if (mathTransformFactory != null && mathTransform != null) {
                MathTransform mathTransform2 = this.transform = this.transform != null ? mathTransformFactory.createConcatenatedTransform(this.transform, mathTransform) : mathTransform;
            }
            if (bl2 && (coordinateOperation instanceof Transformation || coordinateOperation instanceof ConcatenatedOperation) && PositionalAccuracyConstant.getLinearAccuracy(coordinateOperation) != 0.0) {
                if (this.coordinateOperationAccuracy == null) {
                    this.coordinateOperationAccuracy = coordinateOperation.getCoordinateOperationAccuracy();
                } else {
                    this.coordinateOperationAccuracy = null;
                    bl2 = false;
                }
            }
            if (!bl3 || (extent = coordinateOperation.getDomainOfValidity()) == null) continue;
            if (this.domainOfValidity == null) {
                this.domainOfValidity = extent;
                continue;
            }
            if (extent.equals(this.domainOfValidity)) continue;
            this.domainOfValidity = null;
            bl3 = false;
        }
        return coordinateReferenceSystem;
    }

    protected DefaultConcatenatedOperation(ConcatenatedOperation concatenatedOperation) {
        super(concatenatedOperation);
        this.operations = concatenatedOperation.getOperations();
    }

    public static DefaultConcatenatedOperation castOrCopy(ConcatenatedOperation concatenatedOperation) {
        return concatenatedOperation == null || concatenatedOperation instanceof DefaultConcatenatedOperation ? (DefaultConcatenatedOperation)concatenatedOperation : new DefaultConcatenatedOperation(concatenatedOperation);
    }

    public Class<? extends ConcatenatedOperation> getInterface() {
        return ConcatenatedOperation.class;
    }

    @Override
    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                return Objects.equals(this.operations, ((DefaultConcatenatedOperation)object).operations);
            }
            return Utilities.deepEquals(this.getOperations(), ((ConcatenatedOperation)object).getOperations(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(37 * Objects.hashCode(this.operations));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        for (CoordinateOperation coordinateOperation : this.operations) {
            formatter.newLine();
            formatter.append(DefaultConcatenatedOperation.castOrCopy(coordinateOperation));
        }
        formatter.setInvalidWKT(this, null);
        return "ConcatenatedOperation";
    }

    private DefaultConcatenatedOperation() {
        this.operations = Collections.emptyList();
    }

    @XmlElement(name="coordOperation", required=true)
    private CoordinateOperation[] getSteps() {
        List<SingleOperation> list = this.getOperations();
        return list != null ? list.toArray(new CoordinateOperation[list.size()]) : null;
    }

    private void setSteps(CoordinateOperation[] coordinateOperationArray) throws FactoryException {
        this.initialize(null, coordinateOperationArray, DefaultFactories.forBuildin(MathTransformFactory.class));
    }
}

