/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractBoxParser;
import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.Box;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBoxParserImpl
extends AbstractBoxParser {
    Properties mapping;
    Pattern p = Pattern.compile("(.*)\\((.*?)\\)");

    public PropertyBoxParserImpl(String ... customProperties) {
        BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream("/isoparser-default.properties"));
        try {
            this.mapping = new Properties();
            try {
                this.mapping.load(is);
                Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("isoparser-custom.properties");
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    BufferedInputStream customIS = new BufferedInputStream(url.openStream());
                    try {
                        this.mapping.load(customIS);
                    }
                    finally {
                        ((InputStream)customIS).close();
                    }
                }
                String[] stringArray = customProperties;
                int n = customProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    String customProperty = stringArray[n2];
                    this.mapping.load(new BufferedInputStream(this.getClass().getResourceAsStream(customProperty)));
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PropertyBoxParserImpl(Properties mapping) {
        this.mapping = mapping;
    }

    @Override
    public Class<? extends Box> getClassForFourCc(String type, byte[] userType, String parent) {
        FourCcToBox fourCcToBox = new FourCcToBox(type, userType, parent).invoke();
        try {
            return Class.forName(fourCcToBox.clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Box createBox(String type, byte[] userType, String parent) {
        FourCcToBox fourCcToBox = new FourCcToBox(type, userType, parent).invoke();
        String[] param = fourCcToBox.getParam();
        String clazzName = fourCcToBox.getClazzName();
        try {
            if (param[0].trim().length() == 0) {
                param = new String[]{};
            }
            Class<?> clazz = Class.forName(clazzName);
            Class[] constructorArgsClazz = new Class[param.length];
            Object[] constructorArgs = new Object[param.length];
            int i = 0;
            while (i < param.length) {
                if ("userType".equals(param[i])) {
                    constructorArgs[i] = userType;
                    constructorArgsClazz[i] = byte[].class;
                } else if ("type".equals(param[i])) {
                    constructorArgs[i] = type;
                    constructorArgsClazz[i] = String.class;
                } else if ("parent".equals(param[i])) {
                    constructorArgs[i] = parent;
                    constructorArgsClazz[i] = String.class;
                } else {
                    throw new InternalError("No such param: " + param[i]);
                }
                ++i;
            }
            try {
                Constructor<?> constructorObject = param.length > 0 ? clazz.getConstructor(constructorArgsClazz) : clazz.getConstructor(new Class[0]);
                return (Box)constructorObject.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class FourCcToBox {
        private String type;
        private byte[] userType;
        private String parent;
        private String clazzName;
        private String[] param;

        public FourCcToBox(String type, byte[] userType, String parent) {
            this.type = type;
            this.parent = parent;
            this.userType = userType;
        }

        public String getClazzName() {
            return this.clazzName;
        }

        public String[] getParam() {
            return this.param;
        }

        public FourCcToBox invoke() {
            String constructor;
            if (this.userType != null) {
                if (!"uuid".equals(this.type)) {
                    throw new RuntimeException("we have a userType but no uuid box type. Something's wrong");
                }
                constructor = PropertyBoxParserImpl.this.mapping.getProperty(String.valueOf(this.parent) + "-uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty("uuid[" + Hex.encodeHex(this.userType).toUpperCase() + "]");
                }
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty("uuid");
                }
            } else {
                constructor = PropertyBoxParserImpl.this.mapping.getProperty(String.valueOf(this.parent) + "-" + this.type);
                if (constructor == null) {
                    constructor = PropertyBoxParserImpl.this.mapping.getProperty(this.type);
                }
            }
            if (constructor == null) {
                constructor = PropertyBoxParserImpl.this.mapping.getProperty("default");
            }
            if (constructor == null) {
                throw new RuntimeException("No box object found for " + this.type);
            }
            Matcher m = PropertyBoxParserImpl.this.p.matcher(constructor);
            boolean matches = m.matches();
            if (!matches) {
                throw new RuntimeException("Cannot work with that constructor: " + constructor);
            }
            this.clazzName = m.group(1);
            this.param = m.group(2).split(",");
            return this;
        }
    }
}

