/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.PositioningDataInputStream;
import ucar.unidata.io.RandomAccessFile;

public class IospHelper {
    private static boolean showLayoutTypes = false;

    public static Object readDataFill(RandomAccessFile raf, Layout index, DataType dataType, Object fillValue, int byteOrder) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(raf, index, dataType, arr, byteOrder, true);
    }

    public static Object readDataFill(RandomAccessFile raf, Layout index, DataType dataType, Object fillValue, int byteOrder, boolean convertChar) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(raf, index, dataType, arr, byteOrder, convertChar);
    }

    public static Object readData(RandomAccessFile raf, Layout layout, DataType dataType, Object arr, int byteOrder, boolean convertChar) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***RAF LayoutType=" + layout.getClass().getName());
        }
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.ENUM1) {
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.read(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (convertChar && dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readShort(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readInt(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFloat(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readDouble(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readLong(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.read(pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        throw new IllegalStateException("unknown type= " + (Object)((Object)dataType));
    }

    public static Object readDataFill(PositioningDataInputStream is, Layout index, DataType dataType, Object fillValue) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(is, index, dataType, arr);
    }

    public static Object readData(PositioningDataInputStream raf, Layout index, DataType dataType, Object arr) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***PositioningDataInputStream LayoutType=" + index.getClass().getName());
        }
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.OPAQUE || dataType == DataType.ENUM1) {
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            short[] pa = (short[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readShort(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            int[] pa = (int[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readInt(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readFloat(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readDouble(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = (long[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readLong(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            int recsize = index.getElemSize();
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static Object readDataFill(LayoutBB layout, DataType dataType, Object fillValue) throws IOException {
        long size = layout.getTotalNelems();
        if (dataType == DataType.STRUCTURE) {
            size *= (long)layout.getElemSize();
        }
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)size, dataType) : IospHelper.makePrimitiveArray((int)size, dataType, fillValue);
        return IospHelper.readData(layout, dataType, arr);
    }

    public static Object readData(LayoutBB layout, DataType dataType, Object arr) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***BB LayoutType=" + layout.getClass().getName());
        }
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.ENUM1) {
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = bb.get();
                }
            }
            if (dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ShortBuffer buff = chunk.getShortBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                IntBuffer buff = chunk.getIntBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                FloatBuffer buff = chunk.getFloatBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                DoubleBuffer buff = chunk.getDoubleBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                LongBuffer buff = chunk.getLongBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem() * recsize);
                int pos = (int)chunk.getDestElem() * recsize;
                for (int i = 0; i < chunk.getNelems() * recsize; ++i) {
                    pa[pos++] = bb.get();
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static long copyToByteChannel(Array data, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (data instanceof ArrayStructureBB) {
            ArrayStructureBB dataBB = (ArrayStructureBB)data;
            ByteBuffer bb = dataBB.getByteBuffer();
            bb.rewind();
            channel.write(bb);
            return bb.limit();
        }
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        IndexIterator iterA = data.getIndexIterator();
        Class classType = data.getElementType();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeChar(iterA.getCharNext());
            }
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            if (classType == String.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    String s = (String)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, s.length());
                    byte[] b = s.getBytes("UTF-8");
                    outStream.write(b);
                    size += (long)b.length;
                }
                return size;
            }
            if (classType == ByteBuffer.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, bb.limit());
                    bb.rewind();
                    channel.write(bb);
                    size += (long)bb.limit();
                }
                return size;
            }
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return data.getSizeBytes();
    }

    public static void copyFromByteBuffer(ByteBuffer bb, StructureMembers.Member m, IndexIterator result) {
        int offset = m.getDataParam();
        int count = m.getSize();
        DataType dtype = m.getDataType();
        if (dtype == DataType.FLOAT) {
            for (int i = 0; i < count; ++i) {
                result.setFloatNext(bb.getFloat(offset + i * 4));
            }
        } else if (dtype == DataType.DOUBLE) {
            for (int i = 0; i < count; ++i) {
                result.setDoubleNext(bb.getDouble(offset + i * 8));
            }
        } else if (dtype == DataType.INT || dtype == DataType.ENUM4) {
            for (int i = 0; i < count; ++i) {
                result.setIntNext(bb.getInt(offset + i * 4));
            }
        } else if (dtype == DataType.SHORT || dtype == DataType.ENUM2) {
            for (int i = 0; i < count; ++i) {
                result.setShortNext(bb.getShort(offset + i * 2));
            }
        } else if (dtype == DataType.BYTE || dtype == DataType.ENUM1) {
            for (int i = 0; i < count; ++i) {
                result.setByteNext(bb.get(offset + i));
            }
        } else if (dtype == DataType.CHAR) {
            for (int i = 0; i < count; ++i) {
                result.setCharNext((char)bb.get(offset + i));
            }
        } else if (dtype == DataType.LONG) {
            for (int i = 0; i < count; ++i) {
                result.setLongNext(bb.get(offset + i * 8));
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public static Object makePrimitiveArray(int size, DataType dataType) {
        Object[] arr = null;
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.ENUM1 || dataType == DataType.OPAQUE || dataType == DataType.STRUCTURE) {
            arr = new byte[size];
        } else if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            arr = new short[size];
        } else if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            arr = new int[size];
        } else if (dataType == DataType.LONG) {
            arr = new long[size];
        } else if (dataType == DataType.FLOAT) {
            arr = new float[size];
        } else if (dataType == DataType.DOUBLE) {
            arr = new double[size];
        }
        return arr;
    }

    public static Object makePrimitiveArray(int size, DataType dataType, Object fillValue) {
        if (dataType == DataType.BYTE || dataType == DataType.CHAR || dataType == DataType.ENUM1) {
            byte[] pa = new byte[size];
            byte val = (Byte)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.OPAQUE) {
            return new byte[size];
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            short[] pa = new short[size];
            short val = (Short)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            int[] pa = new int[size];
            int val = (Integer)fillValue;
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.LONG) {
            long[] pa = new long[size];
            long val = (Long)fillValue;
            if (val != 0L) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = new float[size];
            float val = ((Float)fillValue).floatValue();
            if ((double)val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = new double[size];
            double val = (Double)fillValue;
            if (val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.STRING) {
            String[] pa = new String[size];
            for (int i = 0; i < size; ++i) {
                pa[i] = (String)fillValue;
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = new byte[size];
            byte[] val = (byte[])fillValue;
            int count = 0;
            while (count < size) {
                for (int i = 0; i < val.length; ++i) {
                    pa[count++] = val[i];
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)DataType.unsignedByteToShort(byteArray[i]);
        }
        return cbuff;
    }

    public static byte[] convertCharToByte(char[] from) {
        int size = from.length;
        byte[] to = new byte[size];
        for (int i = 0; i < size; ++i) {
            to[i] = (byte)from[i];
        }
        return to;
    }

    public static long transferData(Array result, WritableByteChannel channel) throws IOException, InvalidRangeException {
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        IndexIterator iterA = result.getIndexIterator();
        Class classType = result.getElementType();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeChar(iterA.getCharNext());
            }
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return 0L;
    }

    public static Array readSection(ParsedSectionSpec cer) throws IOException, InvalidRangeException {
        Variable inner = null;
        ArrayList<Range> totalRanges = new ArrayList<Range>();
        ParsedSectionSpec current = cer;
        while (current != null) {
            totalRanges.addAll(current.section.getRanges());
            inner = current.v;
            current = current.child;
        }
        Section total = new Section(totalRanges);
        Array result = Array.factory(inner.getDataType(), total.getShape());
        Structure outer = (Structure)cer.v;
        Structure outerSubset = outer.select(cer.child.v.getShortName());
        ArrayStructure outerData = (ArrayStructure)outerSubset.read(cer.section);
        IospHelper.extractSection(cer.child, outerData, result.getIndexIterator());
        result.setUnsigned(cer.v.isUnsigned());
        return result;
    }

    private static void extractSection(ParsedSectionSpec child, ArrayStructure outerData, IndexIterator to) throws IOException, InvalidRangeException {
        long wantNelems = child.section.computeSize();
        StructureMembers.Member m = outerData.findMember(child.v.getShortName());
        int recno = 0;
        while ((long)recno < outerData.getSize()) {
            Array innerData = outerData.getArray(recno, m);
            if (child.child == null) {
                if (wantNelems != innerData.getSize()) {
                    innerData = innerData.section(child.section.getRanges());
                }
                MAMath.copy(child.v.getDataType(), innerData.getIndexIterator(), to);
            } else if (innerData instanceof ArraySequence) {
                IospHelper.extractSectionFromSequence(child.child, (ArraySequence)innerData, to);
            } else {
                if (wantNelems != innerData.getSize()) {
                    innerData = IospHelper.sectionArrayStructure(child, (ArrayStructure)innerData, m);
                }
                IospHelper.extractSection(child.child, (ArrayStructure)innerData, to);
            }
            ++recno;
        }
    }

    private static void extractSectionFromSequence(ParsedSectionSpec child, ArraySequence outerData, IndexIterator to) throws IOException, InvalidRangeException {
        StructureDataIterator sdataIter = outerData.getStructureDataIterator();
        while (sdataIter.hasNext()) {
            StructureData sdata = sdataIter.next();
            StructureMembers.Member m = outerData.findMember(child.v.getShortName());
            Array innerData = sdata.getArray(child.v.getShortName());
            MAMath.copy(m.getDataType(), innerData.getIndexIterator(), to);
        }
    }

    private static ArrayStructure sectionArrayStructure(ParsedSectionSpec child, ArrayStructure innerData, StructureMembers.Member m) throws IOException, InvalidRangeException {
        StructureMembers membersw = new StructureMembers(m.getStructureMembers());
        ArrayStructureW result = new ArrayStructureW(membersw, child.section.getShape());
        int count = 0;
        Section.Iterator iter = child.section.getIterator(child.v.getShape());
        while (iter.hasNext()) {
            int recno = iter.next();
            StructureData sd = innerData.getStructureData(recno);
            result.setStructureData(sd, count++);
        }
        return result;
    }
}

