/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.cataloggen.config.DatasetSource;

public class CatalogGenConfig {
    private static Logger log = LoggerFactory.getLogger(CatalogGenConfig.class);
    private InvDataset parentDataset = null;
    private Type type = null;
    private DatasetSource datasetSource = null;
    private boolean isValid = true;
    private StringBuffer msgLog = new StringBuffer();
    public static final String CATALOG_GEN_CONFIG_NAMESPACE_URI_0_5 = "http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5";

    public CatalogGenConfig(InvDataset parentDataset, String typeName) {
        this(parentDataset, Type.getType(typeName));
    }

    public CatalogGenConfig(InvDataset parentDataset, Type type) {
        log.debug("CatalogGenConfig(): type " + type.toString() + ".");
        this.parentDataset = parentDataset;
        this.type = type;
    }

    public InvDataset getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(InvDataset parentDataset) {
        this.parentDataset = parentDataset;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public DatasetSource getDatasetSource() {
        return this.datasetSource;
    }

    public void setDatasetSource(DatasetSource dsSource) {
        this.datasetSource = dsSource;
    }

    public boolean validate(StringBuilder out) {
        log.debug("validate(): checking if valid");
        this.isValid = true;
        if (this.msgLog.length() > 0) {
            out.append(this.msgLog);
        }
        if (this.getType() == null) {
            this.isValid = false;
            out.append(" ** CatalogGenConfig (3): null value for type is not valid (set with bad string?).");
        }
        this.isValid &= this.getDatasetSource().validate(out);
        log.debug("validate(): isValid=" + this.isValid + " message is\n" + out.toString());
        return this.isValid;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("CatalogGenConfig[type:<").append((Object)this.getType()).append("> child ").append(this.getDatasetSource().toString() + ")]");
        return tmp.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        CATALOG("Catalog"),
        AGGREGATION("Aggregation");

        private String altId;

        private Type(String altId) {
            this.altId = altId;
        }

        public String toString() {
            return this.altId;
        }

        public static Type getType(String altId) {
            if (altId == null) {
                return null;
            }
            for (Type curType : Type.values()) {
                if (!curType.altId.equals(altId)) continue;
                return curType;
            }
            return null;
        }
    }
}

