package Number::Phone::JP::Table::Home;

use strict;
use warnings;

our $VERSION = '0.10';

# Table last modified: 2007-02-01
our %TEL_TABLE = (
    # Area-Prefix => q<Local-Pref-Regex>,
    11   => '(?:(?:7(?:7[0-8]|9[0124-9]|6[1-689]|0[0246-9]|2[1236-9]|5[0-3678]|4[123678]|3[13678]|1[1267]|8\d)|2(?:[68][016-9]|1[0-589]|3[1-46-9]|2[1236-9]|4[0126-9]|5[0126]|[09]\d|7[12])|5(?:9[0-68]|5[125-8]|8[1-58]|7[12378]|1[1238]|3[0-3]|2[012]|6[123]|0[01])|3(?:1[1-9]|0[0-7]|7[02-8]|2[1-5]|4[123]|3[09]|5[01]|9[18]|8\d)|8(?:[038][1-9]|[26][0-8]|1[1-8]|7[1-69]|4[1256]|[59]\d)|6(?:[18][1-68]|6[1-9]|4[0-4]|2[1-4]|9[1459]|3[123]|7[16]|00))\d{4})',
    123  => '(?:(?:[58][02-9]|3[1-9]|7[2-9]|[24]\d|6[68]|90)\d{4})',
    124  => '(?:2[2-9]\d{4})',
    125  => '(?:(?:7[2-9]|6[235-9]|2[2-68]|3[2-578]|5[1-6]|4[1-4]|80)\d{4})',
    126  => '(?:(?:2[02-9]|3[1-9]|5[0-8]|6[2-9]|4[14-7])\d{4})',
    1267 => '(?:[234678]\d{4})',
    133  => '(?:(?:[26][02-9]|7\d)\d{4})',
    134  => '(?:(?:6[124578]|3[1-5]|5[12456]|4[01]|2\d)\d{4})',
    135  => '(?:(?:3[0-8]|4[1-8]|6[0-35-8]|2[1235]|7\d)\d{4})',
    136  => '(?:(?:6[02-9]|4[1-8]|2[12358]|3[1368]|[57]\d)\d{4})',
    137  => '(?:(?:6[02-9]|8[2-9]|50)\d{4})',
    1372 => '(?:[235-8]\d{4})',
    1374 => '(?:[2-9]\d{4})',
    1377 => '(?:[235-8]\d{4})',
    138  => '(?:(?:6[02-8]|7[13-8]|8[2-8]|[2-5]\d|9[136])\d{4})',
    139  => '(?:(?:[45][2-9]|6[02-9])\d{4})',
    1392 => '(?:[25-9]\d{4})',
    1397 => '(?:[235]\d{4})',
    1398 => '(?:[23478]\d{4})',
    142  => '(?:(?:8[2-9]|2[1-57]|7[3-6]|6[568]|3[38]|41)\d{4})',
    143  => '(?:(?:8[0-8]|4[1-8]|2[2-7]|5[05-9]|3[35]|71)\d{4})',
    144  => '(?:(?:[57][1-8]|3[0-8]|8[1-5789]|6[178]|22|96)\d{4})',
    145  => '(?:(?:2[02-9]|4[2-9])\d{4})',
    1456 => '(?:[2-8]\d{4})',
    1457 => '(?:[2-8]\d{4})',
    146  => '(?:(?:[24][02-9]|3[2-9]|50)\d{4})',
    1466 => '(?:[2-8]\d{4})',
    15   => '(?:(?:57[02-9]|48[2-9])\d{4})',
    152  => '(?:(?:[27][02-9]|4[13-8]|6[1-4678]|5[124-7])\d{4})',
    153  => '(?:(?:[78][2-9]|2[02-9]|5[2-8]|6[24-8]|3[58])\d{4})',
    154  => '(?:(?:2[0-689]|3[0125-9]|4[0-7]|9[12589]|[56]\d)\d{4})',
    1547 => '(?:[235-9]\d{4})',
    155  => '(?:(?:3[0-8]|9[13-9]|[2456]\d)\d{4})',
    1558 => '(?:[2-9]\d{4})',
    156  => '(?:(?:6[02-9]|2[2-9])\d{4})',
    1564 => '(?:[24-9]\d{4})',
    157  => '(?:(?:3[0-35-9]|5[1-8]|2[1-6]|6[126-9]|4[12457]|9[1245]|8[89]|77)\d{4})',
    158  => '(?:[248][2-9]\d{4})',
    1586 => '(?:[2-9]\d{4})',
    1587 => '(?:[235-8]\d{4})',
    162  => '(?:(?:2[2-9]|7[23467]|8[2458]|3[234]|41)\d{4})',
    163  => '(?:[68][2-9]\d{4})',
    1632 => '(?:[2-9]\d{4})',
    1634 => '(?:[2-9]\d{4})',
    1635 => '(?:[2-8]\d{4})',
    164  => '(?:(?:2[02-9]|5[03-9]|6[2-9]|3[2-8]|4[023689])\d{4})',
    1648 => '(?:[238]\d{4})',
    165  => '(?:(?:2[2-9]|3[2-8])\d{4})',
    1654 => '(?:[235-9]\d{4})',
    1655 => '(?:[2-9]\d{4})',
    1656 => '(?:[2-9]\d{4})',
    1658 => '(?:[2-9]\d{4})',
    166  => '(?:(?:[235-9]\d|4[05-9])\d{4})',
    167  => '(?:(?:5[2-8]|2[234789]|4[1245]|3[389]|77)\d{4})',
    17   => '(?:7(?:[2-5][1-9]|7[1-79]|6[1-69]|8[1236-9]|1[1568]|99)\d{4})',
    172  => '(?:(?:4[03-9]|9[1235-9]|5[2-5789]|7[235-9]|2[246-9]|6[2589]|[38]\d)\d{4})',
    173  => '(?:(?:7[02-9]|3[03-9]|2[235-9]|5[234678]|4[24569]|6[24789]|8[1248])\d{4})',
    174  => '(?:(?:3[13-8]|2[25789])\d{4})',
    175  => '(?:(?:6[02-9]|7[0-8]|4[1-8]|[23]\d)\d{4})',
    176  => '(?:(?:2[0-8]|7[02-578]|[56]\d)\d{4})',
    178  => '(?:(?:2[0-5789]|3[0-689]|7[0-35-9]|4[13-7]|5[0-356]|6[012478]|8\d|96)\d{4})',
    179  => '(?:(?:2[023578]|3[2-579])\d{4})',
    18   => '(?:8(?:[26][02-9]|[34][1-9]|7[0-5789]|8[0-46-9]|5[1-5789]|0[0-378]|9[2-6]|1[0168])\d{4})',
    182  => '(?:(?:2[02-79]|3[2-8]|4[12457]|5[2356])\d{4})',
    183  => '(?:(?:7[123689]|6[26-9]|4[2367]|5[2568])\d{4})',
    184  => '(?:(?:2[2-5789]|3[2-8]|5[035-9]|4[13469]|6[25679]|7[2-57])\d{4})',
    185  => '(?:(?:5[02-9]|3[02-5789]|8[13-9]|2[2-578]|4[124-7]|7\d)\d{4})',
    186  => '(?:(?:4[1-9]|7[1235-9]|2[235-9]|6[0235679]|8[2478]|[35]\d|9[09])\d{4})',
    187  => '(?:(?:5[02-9]|6[1-9]|7[1-5789]|8[2-9]|4\d|38)\d{4})',
    19   => '(?:(?:6(?:0[013-9]|3[0124-9]|4[1-9]|1[013-689]|2[1-689]|6[1-79]|7[1-8]|5[1-4689]|[89]\d)|90[03789])\d{4})',
    191  => '(?:(?:3[0-689]|2[13-689]|7[124-8]|4[34678]|5[12356]|6[1-5]|8[1248])\d{4})',
    192  => '(?:(?:2[1235-9]|5[3-9]|4\d|33)\d{4})',
    193  => '(?:(?:2[1-9]|6[02-5789]|4[1-6]|3[01368]|5[4579]|[78]\d|90)\d{4})',
    194  => '(?:(?:7[0-35-9]|5[2-9]|[236]\d|40)\d{4})',
    195  => '(?:(?:2[02-9]|[3467]\d|8[89])\d{4})',
    197  => '(?:(?:6[1-9]|7[0-8]|4[1-46-9]|2[2-8]|8[124578]|5[1256]|3\d)\d{4})',
    198  => '(?:(?:6[02-9]|[234]\d|7[789])\d{4})',
    22   => '(?:(?:7(?:[57][1-9]|0[02-9]|3[0-689]|8[0-8]|9[0124-79]|4[1235-8]|6[24-9]|[12]\d)|2(?:[1256][1-9]|0[024-9]|[34789]\d)|3(?:4[1-9]|[05-9]\d))\d{4})',
    220  => '(?:(?:2[0-489]|5[23578]|4[1245]|3[45])\d{4})',
    223  => '(?:[23]\d\d{4})',
    224  => '(?:(?:7[0-35-9]|8[1-9]|[2356]\d|48)\d{4})',
    225  => '(?:(?:[29][0-8]|4[2-9]|6[124-9]|5[03-8]|7[2-79]|8[2-8])\d{4})',
    226  => '(?:(?:2[1-9]|4[1-46-9]|3[124679]|5[56])\d{4})',
    228  => '(?:(?:4[1-79]|2[1-578]|5[24-9]|3[2-589])\d{4})',
    229  => '(?:(?:[235][1-9]|4[02-79]|6[2-9]|8[1-4678]|7[2378]|9[0189])\d{4})',
    23   => '(?:6(?:[24568][1-9]|7[2-79]|1[023568]|0[06-9]|9[345]|3\d)\d{4})',
    233  => '(?:(?:2[2-689]|3[02-6]|4[1-6]|6[2-6]|7[23567]|5[25])\d{4})',
    234  => '(?:(?:2[1-8]|3[0-58]|4[0-5]|5[124679]|7[125-8]|9[1-6]|6[12468])\d{4})',
    235  => '(?:(?:2[2-689]|4[134578]|5[034578]|7[35-8]|3[3458]|6[2468])\d{4})',
    237  => '(?:(?:5[1-9]|4[1-4789]|8[3-8]|2[2-58]|6[02478]|3[3568]|7\d)\d{4})',
    238  => '(?:(?:6[1-7]|7[24-9]|8[03-8]|[2-5]\d|9[38])\d{4})',
    24   => '(?:(?:5(?:[258][1-9]|[67][1-7]|3[13-9]|9[1-8]|0[2-578]|1[15]|4\d)|9(?:[37][1-9]|8[1-79]|9[0-578]|0[013567]|[2456]\d|1[018]))\d{4})',
    240  => '(?:(?:4[013]|[23]\d)\d{4})',
    241  => '(?:(?:2[1-9]|6[02-9]|8[1-4678]|7[123568]|[345]\d|9[028])\d{4})',
    242  => '(?:(?:7[2-9]|3[2346-9]|5[3-9]|6[2-7]|8[2-58]|9[2-6]|2\d|40)\d{4})',
    243  => '(?:(?:5[0-7]|6[1-8]|4[134678]|3[34679]|2[234])\d{4})',
    244  => '(?:(?:3[02-9]|4[0-4678]|6[2-8]|2[2-7]|51)\d{4})',
    246  => '(?:(?:[25][1-9]|4[1-8]|7[2-9]|9[25-9]|[368]\d)\d{4})',
    247  => '(?:(?:2[2-689]|3[2-8]|4[2346-9]|5[13-79]|6[125789]|8[124568]|7\d)\d{4})',
    248  => '(?:(?:2[1-9]|6[0-35-9]|4[1-8]|5[1-578]|7[235-9]|9[2349]|[38]\d)\d{4})',
    25   => '(?:(?:5(?:5[02-9]|6[0-8]|9[2-9]|[234]\d|0[068]|1[124])|2(?:5[0-35-9]|9[0124-9]|[024678]\d|3[0-49]|1[0127])|3(?:7[0-5789]|8[1-8]|6[245789]|1[123]|3[38]|00|21)|7(?:[57][02-9]|9[2-9]|1[01369]|0[068]|[68]\d))\d{4})',
    250  => '(?:(?:2[1-578]|4[0-378]|6[123678]|5[058]|38|79)\d{4})',
    254  => '(?:(?:9[2-9]|3[1235789]|5[0235-8]|6[0246-9]|7[235-9]|[24]\d)\d{4})',
    255  => '(?:(?:7[02-5789]|8[1235-8])\d{4})',
    256  => '(?:(?:3[1-689]|6[0-4678]|7[0235-9]|9[1-578]|4[014-7]|8[25-8]|5[2357]|26)\d{4})',
    257  => '(?:(?:3[0-3578]|4[13578]|2\d)\d{4})',
    258  => '(?:(?:2[0-5789]|8[0-46-9]|4[012467]|5[123589]|7[24-8]|6[1236]|9[245]|3\d)\d{4})',
    259  => '(?:(?:2[02-9]|5[125789]|7[3-8]|6[13678]|8[1678]|3[03])\d{4})',
    26   => '(?:(?:2(?:[2357][1-9]|4[1-8]|6[1-46-9]|0[2-8]|1[34579]|[89]\d)|4(?:8[0-5]|7[4-7]|0[035]|6[268]))\d{4})',
    260  => '(?:(?:3[0-68]|2[24-8])\d{4})',
    261  => '(?:(?:2[123569]|7[12458]|8[2358]|6[126])\d{4})',
    263  => '(?:(?:4[0-8]|7[1-9]|8[1-8]|9[1-5789]|2[04-9]|6[0234679]|[35]\d)\d{4})',
    264  => '(?:(?:2[1-7]|4[0124678]|5[245789]|3[346])\d{4})',
    265  => '(?:(?:2[1-9]|3[02-9]|5[0-79]|9[03-9]|4[3-9]|[78]\d)\d{4})',
    266  => '(?:(?:2[1-4678]|5[2-8]|4[13467]|8[24789]|[67]\d|3[38])\d{4})',
    267  => '(?:(?:[26][2-8]|5[1-8]|9[1236-9]|4[124568]|8[125-8]|3[0-4]|7[03478])\d{4})',
    268  => '(?:(?:2[1-9]|3[13-9]|4[0-69]|6[0-4789]|8[0124-8]|7[1-578]|55)\d{4})',
    269  => '(?:(?:6[2-79]|2[234678]|3[01348]|8[12578]|5[145]|7[47])\d{4})',
    27   => '(?:(?:3(?:6[0-578]|7[0-4678]|8[0124-8]|3[0135789]|4[013-7]|1[058]|5[023]|9[35]|2\d)|2(?:2[013-8]|5[1-8]|8[0345789]|[3469]\d|0[0238]|1[0259])|8(?:9[06-9]|8[018]))\d{4})',
    270  => '(?:(?:2[0-7]|6[1-6]|7[014-7]|3[0-38]|5[05]|8[89]|9[09]|40)\d{4})',
    274  => '(?:(?:5[025-9]|2[02-58]|8[024789]|3[03579]|6[02347]|7[03457]|4[0238])\d{4})',
    276  => '(?:(?:7[0-8]|5[0125-9]|3[0-3678]|4[05-9]|6[0-367]|8[024689]|2[02568]|9[019])\d{4})',
    277  => '(?:(?:7[02346-9]|4[03-8]|5[1-57]|3[028]|6[056]|9[567]|2[02]|8[08])\d{4})',
    278  => '(?:(?:2[0-5]|5[023468]|7[25789]|6[0246]|3[03]|40)\d{4})',
    279  => '(?:(?:8[02-9]|9[024-9]|5[1-69]|6[0346-9]|2[02-6]|7[023567]|3[03]|4[01])\d{4})',
    28   => '(?:(?:6(?:[16][0-79]|3[2-9]|0[015679]|[25789]\d|4[35789])|9(?:3[1-489]|0[028]|2[012]|55)|3(?:0[012567]|4[1678]|3[38]))\d{4})',
    280  => '(?:(?:8[01246-9]|3[0-38]|5[14-7]|7[5-9]|9[12378]|2[1238]|6[1267]|4[078])\d{4})',
    282  => '(?:(?:2[0-5789]|8[0-35-8]|3[0138]|5[1457]|6[1278]|4[345]|9[129]|7[07])\d{4})',
    283  => '(?:(?:2[0-7]|8[04-8]|6[12567]|5[357]|9[01]|78)\d{4})',
    284  => '(?:(?:7[0-47]|4[0-4]|6[1-5]|8[0128]|2[012]|3[38]|9[01]|55)\d{4})',
    285  => '(?:(?:5[0-35-9]|6[1-9]|8[0-8]|7[02-578]|[234]\d)\d{4})',
    287  => '(?:(?:2[0-46-9]|5[013-9]|4[013-8]|8[02-578]|9[236-9]|[367]\d)\d{4})',
    288  => '(?:(?:2[1235-8]|5[013-6]|7[06-9]|3[0124]|9[3678]|8[078]|6[23])\d{4})',
    289  => '(?:(?:7[0-8]|6[02-6]|8[2-68]|9[01359])\d{4})',
    29   => '(?:(?:2(?:5[0-5789]|0[0245789]|8[2-5789]|[234679]\d|1[0259])|3(?:5[02-8]|8[0-578]|7[0134589]|6[0126]|0\d)|8(?:[29][1-9]|[3-8]\d|0[1-48]|1[1789]))\d{4})',
    291  => '(?:(?:3[0-79]|4[04])\d{4})',
    293  => '(?:(?:2[023478]|4[0-46]|3[02357])\d{4})',
    294  => '(?:(?:3[2-9]|5[1-589]|7[0234678]|8[025789]|4[02347]|9[01]|2\d)\d{4})',
    295  => '(?:(?:7[2-9]|6[05]|5\d)\d{4})',
    296  => '(?:(?:3[02-9]|7[0-8]|2[0-68]|5[0124-8]|4[0345789]|8[05-9])\d{4})',
    297  => '(?:(?:[26][0-8]|3[013-9]|7[0-5789]|5[0-578]|4[2-8]|9[014-7]|8\d)\d{4})',
    299  => '(?:(?:[48][02-9]|[26][2346-9]|5[1-9]|3[0-35-8]|9[0-7]|7[0235789])\d{4})',
    3    => '(?:(?:6(?:1(?:[14][0-6]|3[0-79]|9[02-9]|5[2-8]|0[0-46]|2[0-5]|8[5-9]|[67]\d)|5(?:0[0-5789]|4[0-69]|2[4-9]|1[012]|8[78]|3\d|51)|3(?:[356][1-9]|[28][0-8]|0[0-4]|[17]\d)|7(?:4[0-8]|[135-8]\d|9[0-4]|2[012]|0[01])|8(?:[04-9]\d|2[0-6]|3[0-5]|1[012])|6(?:6[0-7]|[45789]\d|3[89])|2(?:[0-3567]\d|8[0-5]|40)|4(?:[0-35]\d|4[017]|7[89])|9(?:1[0-5]|0\d))|4(?:5(?:1[1-59]|4[0-46]|6[012467]|2[01346]|3[01356]|5[03-6]|8[01268]|7[0467]|0[013]|9[06])|4(?:[78][14-7]|1[123567]|3[14569]|6[13-6]|9[3467]|0[05]|2[36]|4[06]|55)|2(?:1[02-68]|[45][136]|[79][126]|3[12356]|2[1236]|8[3458]|6[456]|00)|3(?:3[0-6]|6[0-36]|[48][56]|2[1369]|5[456]|[079]6|1[46]))|5(?:5(?:0[0-689]|[1-8]\d|9[0-35689])|1(?:[0-4689]\d|5[0125-9]|7[0-7])|4(?:[2-9]\d|0[0-589]|1[0-489])|8(?:[0-79]\d|8[013-9])|[023679]\d\d)|3[1-9]\d\d)\d{4})',
    4    => '(?:(?:7(?:1(?:7[0-689]|1[013-8]|[2-689]\d|0[03-8])|0(?:9\d|00))|2(?:9(?:0[0-35789]|[2-69]\d)|00[1-9]))\d{4})',
    42   => '(?:(?:4(?:3[0-46-9]|4[0-689]|[025-9]\d|10)|7(?:[38][02-9]|1[0-689]|[024-79]\d)|5(?:0[0-79]|1[0-689]|[2-9]\d)|8(?:6[0-35-9]|0[0-368]|1[0-4]|[45]\d)|6(?:[78][02-9]|4[1-689]|[23569]\d)|3(?:[02-9]\d|1[0-689])|9(?:1[179]|[78]\d)|20[0127])\d{4})',
    422  => '(?:(?:7[0124-9]|6[06-9]|[2-5]\d|8[0278]|9[01])\d{4})',
    428  => '(?:(?:2[0-578]|3[0-68]|8[2-8]|7[4-9]|9[018])\d{4})',
    43   => '(?:(?:4(?:[47][0-5]|8[13-9]|2[0-48]|6[0-47]|9[678]|[35]\d|00)|3(?:8[02-8]|9[0-5]|3[1239]|5[0156]|1[012]|[07]\d|21|69)|2\d\d)\d{4})',
    436  => '(?:(?:2[0-6]|6[0-367]|7[4-9]|3[03678]|4[0-4]|8[01289]|9[2568]|5[025])\d{4})',
    438  => '(?:(?:2[02358]|3[03678]|7[12357]|6[0234]|9[0178]|4[012]|5[235]|8[08])\d{4})',
    439  => '(?:(?:3[0235789]|5[02-7]|6[5-9]|7[0-37]|2[079]|8[078]|9[01])\d{4})',
    44   => '(?:(?:9(?:3[0-6]|8[0126-9]|5[1-59]|4[45689]|7[5-9]|6[5679]|2[02]|00|11)|5(?:7[1-9]|4[0-489]|0[0-3]|8[0789]|2[02]|5[56]|11|33|67|99)|7(?:5[0-5]|4[0124]|3[389]|9[789]|1[12]|6[67]|7[17]|8[89]|01|22)|8(?:5[02-7]|6[0-356]|7[0-47]|1[1-49]|2[029]|33|44|88)|2(?:7[01267]|[01][01]|2[0-3]|8[0178]|3[038]|4[456]|66|99)|3(?:9[0-6]|3[0137]|2[289]|8\d|44|55|66|79)|4(?:3[01345]|00|11|22|55)|670)\d{4})',
    45   => '(?:(?:8(?:[03][0-6]|6[0-79]|8[1-9]|9[0-8]|7[0-35-8]|1[0-5]|5[1-489]|[24]\d)|2(?:5[0-35-9]|2[1-8]|4[1235-9]|3[125-9]|8[015-8]|6[0-4]|1[012]|[79]\d|0[01])|9(?:[57][1-589]|8[1-9]|4[1-5789]|0[0-59]|1[0-5]|2[0-49]|6[0-4]|3\d)|3(?:2[0-689]|6[0-79]|1[1-79]|4[012589]|5[0-35]|7[0-4]|[039]\d|8[123])|5(?:[17][0-7]|6[0-8]|8[0-6]|3[0-49]|9[0-5]|2[0-3]|5[567]|[04]\d)|4(?:6[1-9]|2[13-9]|3[0-589]|5[0135-9]|1[0-5]|8[1289]|[047]\d|91)|6(?:2[0-589]|1[0-4]|6[1-47]|7[01678]|8[0-3]|4[012]|5[014]|9[345]|0\d|33)|7(?:[039][01]|[1578]\d|2[0-3]|4[1-4]|6[129]))\d{4})',
    46   => '(?:(?:8(?:0[0-8]|6[0124-79]|[2-5789]\d|1[1-7])|2(?:[02-9]\d|1[013-69])|40\d)\d{4})',
    460  => '(?:[2-79]\d{4})',
    463  => '(?:(?:[23][0-8]|6[0-36-9]|4[0-57]|[5789]\d)\d{4})',
    465  => '(?:(?:2[0-5789]|6[0234689]|[3478]\d|5[5789]|9[018])\d{4})',
    466  => '(?:(?:3[0-8]|4[1-9]|6[0-6]|9[0126-9]|5[0-5]|7[0678]|[28]\d)\d{4})',
    467  => '(?:(?:4[0-8]|5[0-5789]|2[2-9]|3[0-3789]|6[0-3678]|9[0125-8]|[78]\d)\d{4})',
    47   => '(?:(?:7(?:2[0-46-9]|1[0136-9]|6[3-9]|5[012458]|7[034589]|0\d)|4(?:[02-9]\d|1[0-39])|3\d\d)\d{4})',
    470  => '(?:(?:2[02-5789]|8[02-8]|4[0134679]|6[0234678]|7[013-7]|5[013578]|3[03678])\d{4})',
    475  => '(?:(?:8[0124-9]|2[02-8]|5[0-578]|4[0234678]|7[0-3678]|6[0678]|3\d)\d{4})',
    476  => '(?:(?:2[0-46-9]|3[0-7]|4[025-9]|7[0-367]|5[0568]|8[0589]|9\d)\d{4})',
    478  => '(?:(?:5[0124-9]|7[0-35789]|8[023678]|6[08])\d{4})',
    479  => '(?:(?:2[0-7]|6[0-4678]|8[024-8]|3[01359]|5[01257]|4[0468]|7\d)\d{4})',
    48   => '(?:(?:2(?:8[0-8]|2[2-9]|9[014-9]|1[0-378]|3[3458]|0[123]|4[012]|7[178]|[56]\d)|4(?:4[1-79]|8[0-35679]|9[0124789]|3[0-47]|2[0-4]|5[01268]|[67]\d|00)|7(?:4[013-9]|1[0124-8]|3[13-9]|8[0-36-9]|5[2-8]|[02679]\d)|6(?:1[0-8]|9[0-589]|5[0-478]|0[0-367]|3[134789]|[24678]\d)|8(?:[49][0-5789]|[1235-8]\d|0[059])|9(?:8[1-9]|[1-79]\d|0[1278])|5(?:[2-9]\d|1[0-48]|0[01678]))\d{4})',
    480  => '(?:(?:3[0-8]|6[1-9]|2[1-689]|5[0235-9]|9[0-36-9]|7[0235-8]|4[023478]|8[015-8])\d{4})',
    49   => '(?:2(?:1[0-8]|[2-9]\d|0[2567])\d{4})',
    493  => '(?:(?:2[1-7]|3[13-689]|5[3-79]|6[123567]|7[1-47]|8[1289]|[49]0)\d{4})',
    494  => '(?:(?:2[1-7]|6[2-69]|7[25-9]|5[3-6]|3[34]|[49]0|88)\d{4})',
    495  => '(?:(?:7[1-8]|2[1-57]|3[2-578]|8[068]|[49]0|55)\d{4})',
    4992 => '(?:[245789]\d{4})',
    4994 => '(?:[2568]\d{4})',
    4996 => '(?:[2789]\d{4})',
    4998 => '(?:[234]\d{4})',
    52   => '(?:(?:7(?:[25][1235-9]|3[0-79]|9[1-9]|4[014-9]|6[0-4689]|0[0-59]|1[0125789]|8[1-489]|7\d)|2(?:2[0-589]|5[1235-9]|0[0-59]|4[1236-9]|9[015-9]|6[1-59]|1[12789]|8[01356]|3[1289]|7\d)|6(?:2[1-79]|1[0-489]|9[1-4689]|5[1-59]|7[15-9]|3[12457]|4[1-46]|0[1-4]|6[015]|8\d)|8(?:3[1-9]|9[1235-9]|7[125-9]|2[1-59]|4[126-9]|6[1-5]|[058]\d|1[19])|9(?:5[0-579]|8[0125-9]|9[015-9]|0[0-389]|7[12379]|[1-4]\d|6[1238])|4(?:4[1-69]|5[1-469]|1[1-49]|8[12356]|0[0189]|3[1239]|6[12]|29|71)|5(?:[58][1-9]|0[1-689]|2[1-46-9]|6[1-69]|3[123]|[47]1|99)|3(?:[05][0-5789]|6[1-9]|4[0135-8]|[123789]\d))\d{4})',
    53   => '(?:(?:5(?:4[0-8]|7[1-9]|2[2-8]|9[2-7]|5[035]|3[03]|8\d|67)|4(?:2[0-8]|4[0-5789]|7[1-9]|8[24-9]|[1356]\d|01))\d{4})',
    531  => '(?:(?:[23][2-9]|45)\d{4})',
    532  => '(?:(?:3[0-5789]|4[13-9]|5[1-8]|6[1-79]|2[1-69]|8[01278]|7[457])\d{4})',
    533  => '(?:(?:7[2-9]|6[35-9]|5[5-9]|9[2-5]|8\d|22|33)\d{4})',
    536  => '(?:(?:[28][2-9]|6[2-7]|7[25-9]|3\d)\d{4})',
    537  => '(?:(?:7[0-57]|3[35-8]|6[1-4]|8[5-8]|5[45]|2\d|48)\d{4})',
    538  => '(?:(?:4[0-589]|8[24-9]|5[15689]|2[1-4]|6[67]|7[47]|3\d)\d{4})',
    539  => '(?:(?:[26][2-9]|8[1-9]|7[347])\d{4})',
    54   => '(?:(?:6(?:3[14-9]|4[13-8]|5[1-69]|6[2-5789]|7[1278]|8[5679]|9[1-4]|[012]\d)|3(?:6[013-9]|4[03-9]|3[03-8]|5[1-57]|7[14-8]|9[3-8]|8[589])|2(?:[39][1-8]|[0125-8]\d|4[5-9])|90[023789])\d{4})',
    544  => '(?:(?:2[1-9]|5[245789]|6[5-8]|9[01]|33)\d{4})',
    545  => '(?:(?:6[0-79]|5[0-7]|7[1-57]|8[1578]|2[123]|[49]0|3\d)\d{4})',
    547  => '(?:(?:3[02-9]|5[3-9]|4[1567]|7[047]|60)\d{4})',
    548  => '(?:(?:2[2-5789]|5[1-58]|3[0234]|8[078]|7[47]|63)\d{4})',
    55   => '(?:(?:2(?:5[1-9]|4[0-4789]|8[0-578]|9[1-8]|0[06-9]|[2367]\d|1[357])|9(?:[2-9]\d|1[25689]|00))\d{4})',
    550  => '(?:(?:7[015-8]|9[08]|8\d|20)\d{4})',
    551  => '(?:(?:2[0-35-9]|3[0235-8]|4[25-8]|75|88|90)\d{4})',
    553  => '(?:(?:3[0-579]|2[0-36]|4[478]|88|90)\d{4})',
    554  => '(?:(?:2[0-6]|6[23678]|4[3568]|5[256]|3[07]|9[01]|88)\d{4})',
    555  => '(?:(?:2[0-589]|8[2-9]|6[023568]|7[23567]|[39]0)\d{4})',
    556  => '(?:(?:6[024-9]|3[2678]|5[0568]|2[027]|4[258])\d{4})',
    557  => '(?:(?:8[0-8]|3[1235-8]|5[1-57]|2[23789]|4[4578]|6[678]|9[05])\d{4})',
    558  => '(?:(?:[67][2-79]|2[2-578]|3[24-8]|5[2-68]|8[013578]|9[04789]|4[235])\d{4})',
    561  => '(?:(?:[36][1-9]|5[1-8]|7[1-689]|8[2-9]|4[1289]|2[018]|97)\d{4})',
    562  => '(?:(?:3[1-689]|4[03-8]|8[2-5789]|9[1235-8]|5[14-7]|2[24]|7[47])\d{4})',
    563  => '(?:(?:5[2-9]|7[2-5789]|6[2-68]|3[2-5]|24)\d{4})',
    564  => '(?:(?:[58][1-9]|3[0-48]|7[1-57]|4[35-8]|6[2-6]|2\d)\d{4})',
    565  => '(?:(?:2[1-9]|8[02-9]|7[124-8]|9[01489]|[3-6]\d)\d{4})',
    566  => '(?:(?:9[1235-9]|4[123568]|5[2-6]|3[3568]|6[1236]|[278]\d)\d{4})',
    567  => '(?:(?:2[2-8]|9[3-9]|5[235-8]|6[4-9]|3[12378]|4[01367]|7[457])\d{4})',
    568  => '(?:(?:[49][1-578]|5[1-9]|3[1-79]|[2678]\d)\d{4})',
    569  => '(?:(?:[48][234789]|6[2-9]|7[1-46-9]|5[568]|[23]\d)\d{4})',
    572  => '(?:(?:6[2-9]|4[345]|[25]\d|3[38]|7[47]|8[78])\d{4})',
    573  => '(?:(?:[56][1-9]|7[02-9]|2[0235-8]|4[35-8]|8[2-58]|38)\d{4})',
    574  => '(?:(?:4[0235-9]|2[3-9]|[567]\d|[38]8)\d{4})',
    575  => '(?:(?:2[0-5789]|3[0-8]|6[235-9]|7[2-5789]|8[2-8]|4[05-9])\d{4})',
    576  => '(?:(?:2[3-8]|5[2-6]|3[2-5]|6[2689]|47|74)\d{4})',
    5769 => '(?:[2-8]\d{4})',
    577  => '(?:(?:3[0-8]|7[02-9]|5[1-79]|6[23578]|25)\d{4})',
    578  => '(?:8[2-9]\d{4})',
    58   => '(?:(?:3(?:2[02-9]|7[0-5789]|5[1-6]|9[1-478]|[18]\d|3[37])|2(?:6[02-9]|5[1-5789]|0[0135-8]|[134789]\d|2[789]))\d{4})',
    581  => '(?:(?:5[1-8]|3[24689]|2[2378]|7[148])\d{4})',
    584  => '(?:(?:[57][1-9]|8[0-5789]|3[02-8]|4[0135-8]|2[023478]|9[1239]|6\d)\d{4})',
    585  => '(?:(?:5[02-8]|3[2-6]|2[123]|4[145]|7[47])\d{4})',
    586  => '(?:(?:2[2-9]|6[1-46-9]|7[1235-8]|4[3-8]|5[123568]|8\d|38)\d{4})',
    587  => '(?:(?:3[02-8]|9[1-8]|8[16-9]|2[1-4]|7[457]|6[56]|5\d)\d{4})',
    59   => '(?:(?:2(?:9[0-8]|5[0-69]|6[124-9]|1[0-5]|[2378]\d|4[2456]|0[12])|3[2-9]\d|99[0139])\d{4})',
    594  => '(?:(?:2[1-9]|3[1-578]|4[0125689]|7[2-8]|8[24678])\d{4})',
    595  => '(?:(?:[48][1-8]|5[0-689]|6[1-9]|2[0-468]|9[23678]|3[6-9]|7[47])\d{4})',
    596  => '(?:(?:3[14-9]|6[2-8]|5[235689]|7[2678]|4[234]|2\d)\d{4})',
    597  => '(?:(?:3[1-9]|2[2-9]|8\d)\d{4})',
    5974 => '(?:[235-9]\d{4})',
    5979 => '(?:[2-9]\d{4})',
    598  => '(?:(?:[78][02-9]|5[0-46-9]|2[0-35689]|6[0-36-9]|4[235-9]|3\d)\d{4})',
    599  => '(?:(?:5[2-9]|2[124568]|6[4-9]|3[23478]|4[3-7]|7[2378]|8[4589])\d{4})',
    6    => '(?:(?:6(?:6(?:[25][1-9]|4[13-9]|3[0-6]|7[1-68]|1[2-68]|8[1-6]|0[5-9]|9\d|61)|8(?:4[0-689]|5[02-8]|7[1235-9]|3[1-68]|6[2-8]|8[12569]|2[179]|1[56]|09)|5(?:1[0-79]|2[0-46-9]|7[1-9]|4[0-68]|6[0-4789]|[03589]\d)|1(?:3[013569]|4[0-37]|9[0-35]|[18][05]|2[0135]|5[0125]|0[015]|6[07]|70)|7(?:[79][0-79]|3[0-46-9]|4[013-8]|5[1-8]|[01268]\d)|9(?:[79][0-8]|[0-68]\d)|4(?:[013-9]\d|2[0-46-9])|[23]\d\d)|7(?:7(?:3[0-39]|1[0-3]|8[129]|0[89]|40|77)|6(?:3[2-9]|6[0-489]|5\d|70|88)|1(?:[78][1-9]|6[1-7])|5(?:9[0-35689]|2[5-8]|0\d)|8(?:9[0-6]|[56]0|78)|4(?:9[234]|10)|22[0-3]|3[345]\d|98[678])|4(?:(?:[37][09]|8[06])\d|9(?:8[01]|6\d|50|77)|25[02-9]|(?:40|56)0))\d{4})',
    72   => '(?:(?:3(?:6[0-35-9]|9[1-9]|2[0-46]|4[01349]|5[0567]|7[237]|8[023]|3\d)|6(?:4[013-9]|[235-9]\d|0[014569])|7(?:[2-9]\d|1[04589]|0[0-3])|2(?:[2-9]\d|0[1-6])|9(?:[2-9]\d|1[1235])|4(?:[2-9]\d|15)|8\d\d)\d{4})',
    721  => '(?:(?:5[0-6]|6[02-589]|3[013458]|8[012789]|7[0248]|9[038]|2\d|40)\d{4})',
    725  => '(?:(?:3[0-35-9]|5[013-8]|4[013-7]|9[029]|2\d)\d{4})',
    73   => '(?:4(?:3[0-79]|4[0124-9]|7[1-9]|1[1-689]|2[1-8]|5[1-79]|9[2-9]|0[02367]|[68]\d)\d{4})',
    735  => '(?:(?:5[02-9]|6[0235-9]|7[2-9]|4[2-79]|2[0-389]|3[1-48])\d{4})',
    736  => '(?:(?:3[2346-9]|2[023568]|4[2346]|5[3-6]|[67]\d|88)\d{4})',
    737  => '(?:(?:2[023568]|6[2-57]|8[23578]|5[237]|3[24])\d{4})',
    738  => '(?:(?:5[2-8]|6[2-68]|2[02349]|4[2-6]|3[2568])\d{4})',
    739  => '(?:(?:7[024-9]|4[235-9]|5[2-8]|8[1-578]|2[02-6]|3[3-7]|6[2-58])\d{4})',
    740  => '(?:(?:2[02-8]|3[0234678])\d{4})',
    742  => '(?:(?:[23][0-7]|6[0-49]|7[0-367]|8[1578]|9[0345]|[45]\d)\d{4})',
    743  => '(?:(?:6[1-9]|8[02-9]|9[2-9]|2[0-3578]|[57]\d)\d{4})',
    744  => '(?:(?:3[2-5789]|5[0124-7]|[24]\d|6[08])\d{4})',
    745  => '(?:(?:5[0-8]|6[0-79]|9[02-8]|3[0-58]|2[1-57]|[478]\d)\d{4})',
    746  => '(?:(?:[36][2-9]|4[234678]|5[2-578])\d{4})',
    7468 => '(?:[2-9]\d{4})',
    747  => '(?:(?:[23][02-9]|5[2-578]|6[2-68])\d{4})',
    748  => '(?:(?:[37][0-8]|[45][0-35-8]|2[02-9]|[68]\d)\d{4})',
    749  => '(?:(?:4[1-9]|3[0-35-8]|7[2346-9]|8[0245689]|6[2-58]|[25]\d)\d{4})',
    75   => '(?:(?:8(?:0[1235-9]|[12][123]|6[1-5]|3[0389]|5[0239]|7[1-4]|4[127]|9[789]|8[12])|2(?:5[1-7]|0[0-5]|8[03-68]|7[5-9]|2[1239]|1[123]|[346]1)|7(?:[07][1235-8]|5[1-7]|[16][12]|2[1-4]|4[1468]|[89]1)|3(?:[4589][1-4]|1[1-6]|2[0-356]|3[0-5]|6[156]|71)|6(?:0[0-6]|4[1-7]|[1678][12]|[39][1-4]|2[123])|4(?:6[1-8]|9[1-6]|1[1457]|3[12]|5[16]|06|41)|5(?:[789][1-5]|5[015-8]|3[123]|0[12]|4[18]|25|61)|9(?:[68][123]|3[1-5]|2[1245]|7[12]|5\d))\d{4})',
    76   => '(?:(?:4(?:7[1-9]|5[0124-8]|1[0-3569]|9[1-6]|[23468]\d|0[03578])|2(?:0[0-5789]|8[0-35-9]|[2-79]\d|1[0-468]))\d{4})',
    761  => '(?:(?:[79][0-8]|2[0-57]|5[0125-8]|4[134678]|6[5-9]|8[039]|3[38])\d{4})',
    763  => '(?:(?:3[02-578]|5[12358]|6[24678]|8[238]|2[23]|77)\d{4})',
    765  => '(?:(?:5[024-8]|2[2-5]|3[1238]|7[2468]|8[2348]|6[25])\d{4})',
    766  => '(?:(?:5[0-79]|7[2-9]|8[2346-9]|3[0-368]|9[125]|[26]\d|4[45])\d{4})',
    767  => '(?:(?:2[2-9]|3[025-8]|4[24-8]|5[234789]|7[024678]|8[3458]|6[268])\d{4})',
    768  => '(?:(?:8[0234678]|3[024678]|2[2368]|4[2356]|5[2678]|6[278]|7[246])\d{4})',
    77   => '(?:5(?:1[0-689]|3[0-79]|8[1-9]|0[0-35679]|[24-7]\d|9[24689])\d{4})',
    770  => '(?:(?:5[02346-9]|3[0236-9]|7[0125-8]|4[35-8]|6[02478]|2\d)\d{4})',
    771  => '(?:(?:5[1-8]|8[2-9]|7[1-7]|6[023568]|4[2-5]|2\d)\d{4})',
    772  => '(?:(?:2[0125-8]|6[0245689]|4[2-7]|7[24-79]|3[23578]|8[2-57])\d{4})',
    773  => '(?:(?:[46][02-9]|2[0-7]|3[02-8]|5[2-9]|7[035-8]|8[2378])\d{4})',
    774  => '(?:(?:7[1-9]|8[0-8]|5[1-8]|3[0-489]|6[2-689]|4[13-68]|9[34589]|2\d)\d{4})',
    776  => '(?:(?:7[02-9]|9[0-8]|6[01346-9]|[2-58]\d)\d{4})',
    778  => '(?:(?:2[1-5789]|3[246-9]|4[2-578]|5[1-5]|6[256]|7[78])\d{4})',
    779  => '(?:(?:6[24-9]|8[35789]|7[789])\d{4})',
    7797 => '(?:[2-6]\d{4})',
    78   => '(?:(?:9(?:9[0-8]|1[1-5789]|5[0-589]|6[1-579]|8[1-7]|3[4-9]|7[4-8]|0[347]|[24]\d)|7(?:[68][1-7]|7[1-9]|3[1-79]|9[1-8]|0[4-9]|5[1-5]|4[1237])|2(?:[45][0126-9]|0[0-7]|6[125-9]|2[0-4]|7[12567]|1[239]|3[012]|8\d|91)|3(?:8[0124-9]|0[2346-9]|3[0-5]|[79][123]|2[12567]|6[01267]|1[0134]|[45]1)|5(?:7[014-9]|9[1-79]|8[1-7]|1[125]|5[56]|[23]1|69)|8(?:[04][12356]|5[14-8]|[268][12]|9[148]|[17]1|39)|6(?:[157][12]|4[12367]|8[1256]|[239]1|00)|4(?:1[1-4]|5[1236]|3[156]|41))\d{4})',
    79   => '(?:(?:2(?:2[1-9]|4[0-8]|5[1-8]|[36-9]\d)|4(?:9[0-8]|[2-5]\d)|5(?:0[0126-9]|[569]\d)|6(?:[67]\d|0[08])|3[23][2-9])\d{4})',
    790  => '(?:(?:[28][0-8]|7[1-9]|3[0-578]|4[2-9]|6\d)\d{4})',
    791  => '(?:(?:[245][02-9]|7[1-8]|6\d)\d{4})',
    794  => '(?:(?:7[0-8]|8[1-9]|6\d)\d{4})',
    795  => '(?:(?:[34][02-9]|8[0-35-9]|[27]\d)\d{4})',
    796  => '(?:(?:2[0-46-9]|9[2-9]|3[2346-9]|5[2-8]|8[0235-8]|4[2-578])\d{4})',
    797  => '(?:(?:7[0-8]|2[0-6]|3[1-58]|5[12567]|9[16-9]|6[1239]|8\d|45)\d{4})',
    798  => '(?:(?:[56][1-9]|7[0-8]|2[02-8]|8[1568]|[34]\d)\d{4})',
    799  => '(?:(?:3[02-9]|5[02-8]|4[2-8]|7[02-57]|8[024568]|6[02456]|2\d)\d{4})',
    82   => '(?:(?:5(?:5[1-9]|3[0-7]|4[1-7]|6[1235789]|8[016-9]|1[0-36]|2[2-57]|7[35-8]|0\d)|8(?:8[0-689]|1[0-589]|2[0-4789]|3[0125-9]|9[02349]|5[0456]|6[2-5]|[47]\d)|2(?:[2-5789]\d|1[125-8]|6[1-47]|0[5789])|9(?:2[1-9]|4[123]|0[09]|6[12])|4(?:[239]\d|00))\d{4})',
    820  => '(?:(?:5[0-8]|2[02-8]|4[05789]|6[256]|7\d|38)\d{4})',
    823  => '(?:(?:[35][0-8]|4[0-5789]|8[1-5789]|6[025689]|[27]\d|90)\d{4})',
    824  => '(?:(?:6[02-9]|8[1-9]|5[1-68]|7[2-8]|4[2348])\d{4})',
    826  => '(?:(?:3[1-8]|5[124-9]|2[2-689]|4[0235-8]|8[2-58]|7[235]|6[02])\d{4})',
    827  => '(?:(?:3[0-5789]|5[2-9]|4[13-8]|8[1-68]|9[1235-8]|2[1-489]|6[2368]|7\d)\d{4})',
    829  => '(?:(?:5[0124568]|7[02478]|8[35-8]|4[045]|3\d|20)\d{4})',
    83   => '(?:(?:9(?:2[0-5789]|5[02-8]|9[2-69]|0[0128]|3[234]|[78]\d|4[12]|6[36])|60[08])\d{4})',
    832  => '(?:(?:6[0-8]|8[1-46-9]|2[0234789]|3[1-578]|4[0125689]|9[1-4]|7[278]|5\d)\d{4})',
    833  => '(?:(?:7[1-9]|4[13-8]|5[123578]|9[12]|60|87)\d{4})',
    834  => '(?:(?:2[0-35-9]|6[0-46-9]|8[2-9]|3[1-4689]|5[127]|4[01]|91)\d{4})',
    835  => '(?:(?:3[1-689]|5[02-8]|6[28]|2\d|80|91)\d{4})',
    836  => '(?:(?:[37][1-9]|[58][1-589]|6[024-9]|4[013458]|2[129]|9[128])\d{4})',
    837  => '(?:(?:2[1235-9]|5[02-8]|7[0124-8]|3[2-8]|8[02-68]|4[0238]|6\d)\d{4})',
    838  => '(?:(?:[25][1-8]|4[07])\d{4})',
    8387 => '(?:[2-9]\d{4})',
    8388 => '(?:[2-9]\d{4})',
    8396 => '(?:[258]\d{4})',
    84   => '(?:9(?:6[0-8]|8[0-4678]|9[0-389]|[2-57]\d|0[5-8]|1[689])\d{4})',
    845  => '(?:(?:2[02-9]|33)\d{4})',
    846  => '(?:(?:2[1-9]|6[2-9]|4[05-8]|3[138])\d{4})',
    847  => '(?:(?:[23][2-5789]|4[013-9]|8[2-9]|5[1-578]|6[012678])\d{4})',
    8477 => '(?:[2-9]\d{4})',
    848  => '(?:(?:2[0-579]|4[014-8]|3[023678]|7[035-8]|8[15-9]|5[1567]|6\d)\d{4})',
    8512 => '(?:[2-8]\d{4})',
    8514 => '(?:[24678]\d{4})',
    852  => '(?:(?:6[0125-8]|5[2-589]|7[235-8]|4[0-4]|8[1258]|[23]\d)\d{4})',
    853  => '(?:(?:2[0-578]|6[2346-9]|3[01358]|8[04568]|4[358]|5[234]|7[237])\d{4})',
    854  => '(?:(?:[35][02-8]|2[1-4678]|7[2-7]|6[1248]|[48]\d|90)\d{4})',
    855  => '(?:(?:[38][2-578]|2[2-9]|5[0-7]|7[024-8]|4[024578]|9[2357]|6[568])\d{4})',
    856  => '(?:(?:2[2-9]|5[02568]|3[128]|7\d|40|88)\d{4})',
    857  => '(?:(?:3[0-35-9]|7[02-8]|8[24-8]|6[01257]|[25]\d|44)\d{4})',
    858  => '(?:(?:8[02-9]|2[2346-9]|3[2-8]|4[0345789]|5[023578]|6[08]|7\d)\d{4})',
    859  => '(?:(?:2[1-9]|6[02-68]|4[24-8]|7[024578]|8[23478]|[35]\d)\d{4})',
    86   => '(?:(?:2(?:[26][1-9]|8[0-79]|9[02-9]|5[0-69]|0[016-9]|4[1-6]|[37]\d|1[24])|4(?:7[02-9]|4[0124-8]|8[02-689]|3[02-68]|5[014-8]|6[0-6]|2\d)|9(?:4[0-8]|0[1235-8]|5\d)|8(?:9[0-4789]|0[0-5])|5(?:2[2-8]|52)|60[08])\d{4})',
    863  => '(?:(?:[24][13]|3[0-3]|7[1367]|5[135]|8[138]|66)\d{4})',
    8636 => '(?:[235789]\d{4})',
    865  => '(?:(?:4[2-578]|7[012578]|5[48]|6\d)\d{4})',
    866  => '(?:(?:2[1235689]|5[124-8]|8[023478]|3[01378]|4[02568]|6[23567]|7[2-57]|9\d)\d{4})',
    867  => '(?:(?:[25][02-8]|7[0124-8]|9[2-68]|3[34578]|4[12456]|6[25-8]|8[08])\d{4})',
    868  => '(?:(?:3[0-35-9]|5[24-8]|6[246-9]|4[02468]|[27]\d|88)\d{4})',
    869  => '(?:(?:2[0124-9]|6[2-79]|8[04589]|7[248]|9[23]|34)\d{4})',
    8699 => '(?:[5789]\d{4})',
    87   => '(?:8(?:4[0-5789]|6[1-9]|7[013-9]|1[0-68]|8[1235-9]|2[123567]|[0359]\d)\d{4})',
    875  => '(?:(?:5[024-8]|2[34579]|8[23489]|7[2347]|6[237])\d{4})',
    877  => '(?:(?:4[1-9]|2[1-5789]|8[3-9]|7[035789]|3[2-58]|5[5-9]|6[2346]|98)\d{4})',
    879  => '(?:(?:2[2-79]|6[124578]|5[23567]|4[2389]|7[5679]|8[24]|33)\d{4})',
    88   => '(?:(?:6(?:6[1-9]|7[0124-9]|8[02-9]|5[2-7]|1[12568]|[2349]\d|0[0238])|8(?:7[1-9]|[08][02-58]|9[1-7]|[2-6]\d|1[389]))\d{4})',
    880  => '(?:(?:3[1-9]|8[02-9]|6[2-9]|7[02-79]|5[02-68]|4[3469]|2\d|91)\d{4})',
    883  => '(?:(?:7[024-9]|8[02-8]|5[0-3568]|6[2-8]|2[24-7]|3[03568]|4[235])\d{4})',
    884  => '(?:(?:2[1-8]|3[3-68]|4[02459]|[67]\d|81)\d{4})',
    885  => '(?:(?:3[2-9]|4[2-8])\d{4})',
    887  => '(?:(?:2[02-9]|4[2-578]|8[2348]|[357]\d|9[078]|6[09])\d{4})',
    889  => '(?:(?:4[02-9]|3[2-79]|5[24-9]|2[024678]|6[25-8])\d{4})',
    89   => '(?:9(?:0[013-9]|4[0-35-9]|8[2-9]|[1235679]\d)\d{4})',
    892  => '(?:(?:5[024-8]|2[1278]|4[19]|31)\d{4})',
    893  => '(?:(?:4[134579]|5[023479]|2[3-7]|3[3479])\d{4})',
    894  => '(?:(?:2[0-46-9]|3[3-9]|6[24-9]|5[234678]|7[25-8]|8[23589]|4[07])\d{4})',
    895  => '(?:(?:2[02-9]|4[2-9]|8[2-5789]|6[02-58]|7[02-57]|3[02567]|5[02458])\d{4})',
    896  => '(?:(?:2[2-689]|5[5-9]|7[2457]|49|88)\d{4})',
    897  => '(?:(?:3[1-9]|5[1235-9]|7[02-8]|8[2-9]|4[013-7]|2[02789]|6[4-7])\d{4})',
    898  => '(?:(?:3[1-689]|2[2-578]|7[235-8]|5[2-6]|6[4-8]|4[1378]|80)\d{4})',
    92   => '(?:(?:6(?:2[1-79]|0[035-9]|6[1-589]|8[123678]|[159][12]|4[1-5]|7[1-4]|3[123])|5(?:[279][1-7]|5[1-9]|6[1-8]|0[0-5]|3[1-5]|[18]\d|4[12])|8(?:[46][1-7]|0[1-9]|[37][1-6]|[125][123]|8[1-58]|9[0-5])|2(?:[08][1-9]|1[0-5]|6[0-4]|7[0-3]|3[135]|9[012]|22)|7(?:3[1-9]|7[15-9]|5[123]|[12]\d|[489]1|0[78]|6[12])|9(?:1[1-5789]|5[1-4678]|8[0-6]|[234]\d|6[123]|76)|3(?:9[0-35-9]|3[0-578]|[125-8]\d|4[012456]|03)|4(?:[37][1-7]|8[123]|[01]\d|5[12]|[46]1))\d{4})',
    920  => '(?:[458][02-9]\d{4})',
    93   => '(?:(?:6(?:1[1-9]|4[1-7]|[237][12]|[68][123]|9[1-5]|0[0-3]|5[1-4])|5(?:5[13-8]|[367][123]|[29][12]|1[1-4]|8[1238]|00|41)|9(?:6[1-7]|2[1-4]|5[123]|3[12]|8[01]|41)|2(?:3[0-8]|[029][123]|4[3-7]|8\d)|3(?:[78][123]|[24][12]|3[0-3]|9[15])|7(?:[49][12]|7[1267]|5[123]|[06]1)|4(?:7[1-7]|[58][123]|3[456])|8(?:8[1-489]|[67][123]))\d{4})',
    930  => '(?:(?:[25][2-8]|3[0-357]|4[2358])\d{4})',
    940  => '(?:(?:4[12378]|2[256]|5[125]|7[27]|3\d|62)\d{4})',
    942  => '(?:(?:2[0-35-9]|5[0-578]|7[0235-8]|9[012456]|[348]\d|6[245])\d{4})',
    943  => '(?:(?:7[02-9]|3[0-7]|4[12357]|2[2-5]|5[2458]|88)\d{4})',
    944  => '(?:(?:7[0-8]|6[234789]|8[5-9]|3[1238]|4[0134]|2[12]|5\d)\d{4})',
    946  => '(?:(?:2[1-9]|3[013]|7[247]|4[12]|5[25]|6[23])\d{4})',
    947  => '(?:(?:4[1-9]|2[2368]|7[2357]|8[2458]|3[123]|6[23]|50)\d{4})',
    948  => '(?:(?:3[01358]|5[2357]|8[0238]|4[23]|6[25]|7[27]|2\d)\d{4})',
    949  => '(?:(?:2[2-9]|3[02-6]|5[24578]|4[23])\d{4})',
    9496 => '(?:[235-8]\d{4})',
    95   => '(?:8(?:1[0-689]|5[0124-9]|6[0-8]|7[0-3789]|[023489]\d)\d{4})',
    950  => '(?:(?:5[013578]|3[19]|2\d)\d{4})',
    952  => '(?:(?:4[013-8]|6[0-68]|7[1-8]|8[1-7]|[2359]\d)\d{4})',
    954  => '(?:(?:6[02-9]|2[0234678]|3[1368]|4[0235]|7[018])\d{4})',
    955  => '(?:(?:7[02-9]|4[1235-8]|5[1-68]|6[2-57]|3[1258]|8[028]|2\d)\d{4})',
    956  => '(?:(?:4[0125-9]|6[02-689]|7[2-9]|8[0235789]|5[015689]|[23]\d)\d{4})',
    957  => '(?:(?:3[1-9]|6[1-8]|8[124-8]|[2457]\d)\d{4})',
    959  => '(?:(?:[57][1-9]|3[0-79]|4[2-9]|8[234678]|6[468]|2\d)\d{4})',
    96   => '(?:(?:2(?:8[1-9]|4[0-35789]|7[2-9]|2[0-3578]|3[2-578]|9[2-7]|1[1-5]|0[0167])|3(?:[02-9]\d|1[0-59]))\d{4})',
    964  => '(?:(?:[25][2-9]|3[0-57]|4[1235-8])\d{4})',
    965  => '(?:(?:4[13-6]|5[1235]|6[257]|8[08]|3\d|28|77)\d{4})',
    966  => '(?:(?:2[02-9]|3[1-9]|4[2-9]|6[1236-9]|8[2346-9]|7[178])\d{4})',
    967  => '(?:(?:6[02-8]|7[0-7]|2[2-578]|3[1-59]|8[2-58]|4[2468]|9[018])\d{4})',
    968  => '(?:(?:7[1-9]|2[2-8]|3[1-4678]|4[1-4689]|6[2-689]|8[024-8]|5[1379])\d{4})',
    969  => '(?:(?:7[02-9]|3[1-79]|2[2-8]|6[2346-9]|5[234678]|4[2567]|8[78])\d{4})',
    97   => '(?:5(?:9[02-9]|[02-578]\d|1[0-58]|6[0789])\d{4})',
    972  => '(?:(?:[58][2-8]|3[0-79]|6[1-8]|4[2-68]|7[279]|2\d)\d{4})',
    973  => '(?:(?:7[02-9]|5[2-8]|8[078]|2\d|31)\d{4})',
    974  => '(?:(?:6[02-9]|7[0-8]|4[024579]|2[24678]|3[12457])\d{4})',
    977  => '(?:(?:7[0235-8]|8[04568]|3[38]|6[67]|2\d|44|51)\d{4})',
    978  => '(?:(?:6[02-9]|3[0-4678]|2[2-8]|7[1-4678]|8[234789]|4[12489]|5[2-58]|9[178])\d{4})',
    979  => '(?:(?:2[1-7]|8[2-578]|3[0-38]|5[2-6]|4[13]|6[24]|7[27])\d{4})',
    98   => '(?:(?:9(?:5[1-9]|7[0-5789]|0[0-36-9]|1[13-9]|9[2-9]|2[0-3679]|8[235789]|[346]\d)|8(?:0[0-8]|[2-9]\d|1[2-9]))\d{4})',
    980  => '(?:(?:[78][02-9]|[45]\d|38)\d{4})',
    9802 => '(?:[23479]\d{4})',
    982  => '(?:(?:7[1-8]|8[1-46-9]|9[0-3567]|[2-6]\d)\d{4})',
    983  => '(?:(?:4[1-9]|2[1-8]|3\d)\d{4})',
    984  => '(?:(?:2[1-7]|4[0124678]|3[1357])\d{4})',
    985  => '(?:(?:4[0-5789]|7[1-578]|[235689]\d)\d{4})',
    986  => '(?:(?:5[1-5789]|7[24-9]|3[036-9]|4[4-7]|6[2468]|8[08]|2\d)\d{4})',
    987  => '(?:(?:2[1-9]|7[0-8]|3[123]|5[568]|6[478])\d{4})',
    99   => '(?:(?:2(?:0[0-46-9]|1[02-689]|9[2-9]|7[1-68]|8[1-6]|[2-6]\d)|8(?:0[013-9]|3[013678]|1[1-4]|2[128])|4(?:8[0-8]|7\d|00))\d{4})',
    9912 => '(?:[23479]\d{4})',
    9913 => '(?:[2379]\d{4})',
    993  => '(?:(?:3[1-9]|2[1-8]|5[1235-9]|8[3-9]|6[234678]|4[13579]|7[23678])\d{4})',
    994  => '(?:(?:2[02-9]|3[0-8]|5[12358]|6[23578]|9[018]|4\d)\d{4})',
    995  => '(?:(?:2[02-9]|7[0-8]|6[2-9]|[45]\d|3[18])\d{4})',
    996  => '(?:(?:6[1-9]|7[1-5789]|8[2-9]|4[124578]|[235]\d)\d{4})',
    9969 => '(?:[2-9]\d{4})',
    997  => '(?:(?:[247][02-9]|5[0-8]|8[1-689]|6[235-9]|9[237])\d{4})',
);

1;
__END__
