#include <xs/xs.h>
#include <xs/lib/merge.h>

static int aaa = 0;

typedef OP* (*opcheck_t) (pTHX_ OP* op);
static opcheck_t orig_opcheck = NULL;

static OP* pp_sassign (pTHX) {
    dSP;
    SV* left = *SP; SV* right = *(SP-1);

    if (PL_op->op_private & OPpASSIGN_BACKWARDS) {
        SV*const temp = left;
        left = right; right = temp;
    }
    
    if (SvROK(left) && SvROK(right) && SvTYPE(SvRV(left)) == SvTYPE(SvRV(right)) && SvTYPE(SvRV(left)) == SVt_PVHV) {
        xs::lib::merge(aTHX_ left, right);
        POPs; SETs(left);
        return NORMAL;
    }
    
    return PL_ppaddr[PL_op->op_type](aTHX);
}

static OP* opcheck (pTHX_ OP* op) {
    const char* packname = SvPVX(PL_curstname);
    STRLEN packlen = SvCUR(PL_curstname);
    if (packlen < 2 || packname[0] != 'N' || packname[1] != 'S') return op;
    if (packlen > 2 && (packname[2] != ':' || packname[3] != ':')) return op;
    op->op_ppaddr = pp_sassign;
    return op;
}

static void enable_op_tracking (pTHX) {
    if (PL_check[OP_SASSIGN] == opcheck) return;
    orig_opcheck = PL_check[OP_SASSIGN];
    PL_check[OP_SASSIGN] = opcheck;
}

static void disable_op_tracking (pTHX) {
    if (PL_check[OP_SASSIGN] != opcheck) return;
    PL_check[OP_SASSIGN] = orig_opcheck;
    orig_opcheck = NULL;
}

MODULE = Panda::Config::Perl                PACKAGE = Panda::Config::Perl
PROTOTYPES: DISABLE

void enable_op_tracking () {
    enable_op_tracking(aTHX);
}

void disable_op_tracking () {
    disable_op_tracking(aTHX);
}
