#include <stdlib.h>
#include <stdint.h>

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#include <wiringPi.h>
#include <lcd.h>

/*
    not yet implemented

    # core

    extern void pinModeAlt          (int pin, int mode) ;
    extern int  analogRead          (int pin) ;
    extern void analogWrite         (int pin, int value) ;

    # board

    extern          void setPadDrive         (int group, int value) ;
    extern          void pwmToneWrite        (int pin, int freq) ;
    extern          void digitalWriteByte    (int value) ;
    extern unsigned int  digitalReadByte     (void) ;
    extern          void pwmSetMode          (int mode) ;
    extern          void pwmSetClock         (int divisor) ;
    extern          void gpioClockSet        (int pin, int freq) ;

    # lcd

    extern void lcdHome        (const const int fd) ;
    extern void lcdClear       (const const int fd) ;
    extern void lcdDisplay     (const const int fd, int state) ;
    extern void lcdCursor      (const const int fd, int state) ;
    extern void lcdCursorBlink (const const int fd, int state) ;
    extern void lcdSendCommand (const const int fd, unsigned char command) ;
    extern void lcdPosition    (const const int fd, int x, int y) ;
    extern void lcdCharDef     (const const int fd, int index, unsigned char data [8]) ;
    extern void lcdPutchar     (const const int fd, unsigned char data) ;
    extern void lcdPuts        (const const int fd, const char *string) ;
    extern void lcdPrintf      (const const int fd, const char *message, ...) ;

    extern int  lcdInit (const int rows, const int cols, const int bits,
    	const int rs, const int strb,
    	const int d0, const int d1, const int d2, const int d3, const int d4,
    	const int d5, const int d6, const int d7) ;

*/

MODULE = RPi::WiringPi::Core  PACKAGE = RPi::WiringPi::Core

#
# core
#

int
wiringPiSetup()

int
wiringPiSetupSys()

int
wiringPiSetupGpio()

int wiringPiSetupPhys()

void
pinMode(pin, mode)
    int pin
    int mode

void
pullUpDnControl(pin, pud)
    int pin
    int pud

int
digitalRead(pin)
    int pin

void
digitalWrite(pin, value)
    int pin
    int value

void
digitalWriteByte(value)
    int value

void
pwmWrite(pin, value)
    int pin
    int value

int
getAlt(pin)
    int pin

#
# board
#

int
piBoardRev()

int 
wpiPinToGpio(wpiPin)
    int wpiPin

int 
physPinToGpio(physPin)
    int physPin

void
pwmSetRange(range)
    unsigned int range

#
# lcd
#

int
lcdInit(rows, cols, bits, rs, strb, d0, d1, d2, d3, d4, d5, d6, d7)
    int rows
    int cols
    int bits
    int rs
    int strb
    int d0
    int d1
    int d2
    int d3
    int d4
    int d5
    int d6
    int d7

void
lcdHome(fd)
    int fd

void
lcdClear(fd)
    int fd

void
lcdDisplay(fd, state)
    int fd
    int state

void
lcdCursor(fd, state)
    int fd
    int state

void
lcdCursorBlink(fd, state)
    int fd
    int state

void
lcdSendCommand(fd, command)
    int fd
    char command

void
lcdPosition(fd, x, y)
    int fd
    int x
    int y

void
lcdCharDef(fd, index, data)
    int fd
    int index
    unsigned char *data

void
lcdPutchar(fd, data)
    int fd
    unsigned char data

void lcdPuts(fd, string)
    int fd
    char *string

void
lcdPrintf(fd, message)
    int fd
    char *message
